/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.model;

import hudson.plugins.global_build_stats.FieldFilter;
import hudson.plugins.global_build_stats.FieldFilterFactory;
import hudson.plugins.global_build_stats.model.BuildResult;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class BuildSearchCriteria {
    private String jobFilter = "ALL";
    transient FieldFilter calculatedJobFilter = null;
    private String nodeFilter = "ALL";
    transient FieldFilter calculatedNodeFilter = null;
    private String launcherFilter = "ALL";
    transient FieldFilter calculatedLauncherFilter = null;
    private short shownBuildResults;

    @Deprecated
    public BuildSearchCriteria(String _jobFilter, String _nodeFilter, boolean _successShown, boolean _failuresShown, boolean _unstablesShown, boolean _abortedShown, boolean _notBuildsShown) {
        this(_jobFilter, _nodeFilter, "ALL", _successShown, _failuresShown, _unstablesShown, _abortedShown, _notBuildsShown);
    }

    public BuildSearchCriteria(String _jobFilter, String _nodeFilter, String _launcherFilter, boolean _successShown, boolean _failuresShown, boolean _unstablesShown, boolean _abortedShown, boolean _notBuildsShown) {
        this.setJobFilter(_jobFilter);
        this.setNodeFilter(_nodeFilter);
        this.setLauncherFilter(_launcherFilter);
        this.shownBuildResults = 0;
        this.shownBuildResults = (short)(this.shownBuildResults | (_successShown ? BuildResult.SUCCESS.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (_failuresShown ? BuildResult.FAILURE.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (_unstablesShown ? BuildResult.UNSTABLE.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (_abortedShown ? BuildResult.ABORTED.code : (short)0));
        this.shownBuildResults = (short)(this.shownBuildResults | (_notBuildsShown ? BuildResult.NOT_BUILD.code : (short)0));
    }

    public boolean isJobResultEligible(JobBuildResult result) {
        boolean jobBuildEligible = true;
        jobBuildEligible &= this.getCalculatedJobFilter().isFieldValueValid(result.getJobName());
        jobBuildEligible &= this.getCalculatedNodeFilter().isFieldValueValid(result.getNodeName());
        jobBuildEligible &= this.getCalculatedLauncherFilter().isFieldValueValid(result.getUserName());
        jobBuildEligible &= this.isAbortedShown() || result.getResult().getAbortedCount() != 1;
        jobBuildEligible &= this.isFailuresShown() || result.getResult().getFailureCount() != 1;
        jobBuildEligible &= this.isNotBuildShown() || result.getResult().getNotBuildCount() != 1;
        jobBuildEligible &= this.isSuccessShown() || result.getResult().getSuccessCount() != 1;
        return jobBuildEligible &= this.isUnstablesShown() || result.getResult().getUnstableCount() != 1;
    }

    public void setJobFilter(String jobFilter) {
        this.jobFilter = jobFilter;
        this.calculatedJobFilter = FieldFilterFactory.createFieldFilter((String)jobFilter);
    }

    public void setNodeFilter(String nodeFilter) {
        this.nodeFilter = nodeFilter;
        this.calculatedNodeFilter = FieldFilterFactory.createFieldFilter((String)nodeFilter);
    }

    public void setLauncherFilter(String launcherFilter) {
        this.launcherFilter = launcherFilter;
        this.calculatedLauncherFilter = FieldFilterFactory.createFieldFilter((String)launcherFilter);
    }

    protected FieldFilter getCalculatedJobFilter() {
        if (this.calculatedJobFilter == null) {
            this.calculatedJobFilter = FieldFilterFactory.createFieldFilter((String)this.jobFilter);
        }
        return this.calculatedJobFilter;
    }

    protected FieldFilter getCalculatedNodeFilter() {
        if (this.calculatedNodeFilter == null) {
            this.calculatedNodeFilter = FieldFilterFactory.createFieldFilter((String)this.nodeFilter);
        }
        return this.calculatedNodeFilter;
    }

    protected FieldFilter getCalculatedLauncherFilter() {
        if (this.calculatedLauncherFilter == null) {
            this.calculatedLauncherFilter = FieldFilterFactory.createFieldFilter((String)this.launcherFilter);
        }
        return this.calculatedLauncherFilter;
    }

    @Exported
    public boolean isSuccessShown() {
        return (this.shownBuildResults & BuildResult.SUCCESS.code) != 0;
    }

    @Exported
    public boolean isFailuresShown() {
        return (this.shownBuildResults & BuildResult.FAILURE.code) != 0;
    }

    @Exported
    public boolean isUnstablesShown() {
        return (this.shownBuildResults & BuildResult.UNSTABLE.code) != 0;
    }

    @Exported
    public boolean isAbortedShown() {
        return (this.shownBuildResults & BuildResult.ABORTED.code) != 0;
    }

    @Exported
    public boolean isNotBuildShown() {
        return (this.shownBuildResults & BuildResult.NOT_BUILD.code) != 0;
    }

    @Exported
    public String getJobFilter() {
        return this.jobFilter;
    }

    @Exported
    public String getNodeFilter() {
        return this.nodeFilter;
    }

    @Exported
    public String getLauncherFilter() {
        return this.launcherFilter;
    }

    public void setShownBuildResults(short shownBuildResults) {
        this.shownBuildResults = shownBuildResults;
    }
}

