/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.xstream.migration.v7;

import hudson.model.AbstractBuild;
import hudson.plugins.global_build_stats.JobBuildResultFactory;
import hudson.plugins.global_build_stats.model.BuildSearchCriteria;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.xstream.migration.AbstractMigrator;
import hudson.plugins.global_build_stats.xstream.migration.v6.V6GlobalBuildStatsPOJO;
import hudson.plugins.global_build_stats.xstream.migration.v7.V7GlobalBuildStatsPOJO;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class V6ToV7Migrator
extends AbstractMigrator<V6GlobalBuildStatsPOJO, V7GlobalBuildStatsPOJO> {
    protected V7GlobalBuildStatsPOJO createMigratedPojo() {
        return new V7GlobalBuildStatsPOJO();
    }

    protected List<BuildStatConfiguration> migrateBuildStatConfigs(List<BuildStatConfiguration> buildStatConfigs) {
        ArrayList<BuildStatConfiguration> migratedBuildStatConfigs = new ArrayList<BuildStatConfiguration>();
        for (BuildStatConfiguration cfg : buildStatConfigs) {
            BuildSearchCriteria criteria = new BuildSearchCriteria(cfg.getBuildFilters().getJobFilter(), cfg.getBuildFilters().getNodeFilter(), "ALL", cfg.getBuildFilters().isSuccessShown(), cfg.getBuildFilters().isFailuresShown(), cfg.getBuildFilters().isUnstablesShown(), cfg.getBuildFilters().isAbortedShown(), cfg.getBuildFilters().isNotBuildShown());
            cfg.setBuildFilters(criteria);
            migratedBuildStatConfigs.add(cfg);
        }
        return migratedBuildStatConfigs;
    }

    protected List<JobBuildResult> migrateJobBuildResults(List<JobBuildResult> jobBuildResults) {
        ArrayList<JobBuildResult> migratedJobBuildResults = new ArrayList<JobBuildResult>();
        for (JobBuildResult jbr : jobBuildResults) {
            AbstractBuild b = V6ToV7Migrator.retrieveBuildFromJobBuildResult((JobBuildResult)jbr);
            if (b != null) {
                String userName = JobBuildResultFactory.extractUserNameIn((AbstractBuild)b);
                jbr.setUserName(userName);
            }
            migratedJobBuildResults.add(jbr);
        }
        return migratedJobBuildResults;
    }
}

