function fieldFilterTypeSelected(selectedType, regexInputFieldId, filterHiddenInputFieldId){
	if(FIELD_FILTER_ALL == selectedType){
		$(regexInputFieldId).disabled = true;
		$(filterHiddenInputFieldId).value = FIELD_FILTER_ALL;
	} else if(FIELD_FILTER_REGEX == selectedType){
		$(regexInputFieldId).disabled = false;
		$(filterHiddenInputFieldId).value = FIELD_FILTER_REGEX+'('+$(regexInputFieldId).value+')';
	} else if(selectedType.indexOf(FIELD_FILTER_REGEX) != -1){
		$(regexInputFieldId).disabled = true;
		$(filterHiddenInputFieldId).value = selectedType;
	}
}
	
function initializeRegexField(targetField, regex){
	var extractingRegex = new RegExp("^"+FIELD_FILTER_REGEX+"\\((.*)\\)$", "g");
	if(extractingRegex.test(regex)){
		extractingRegex.exec(regex);
		var regexToPut = RegExp.$1;
		$(targetField).value = regexToPut;
	}
}

// Reinventing the wheel since in hudson-behavior.js we MUST
// use a <tr> and <td> field for the validation-error-area container :(
// So registerValidator implementation is recopied here
function validateField(field){
    var validationErrorAreaClassName = field.getAttribute("validationErrorAreaClassName");
    if (!validationErrorAreaClassName) validationErrorAreaClassName = "validation-error-area";
    
    var targetValidationError = findFollowingSPAN(field, validationErrorAreaClassName);
    var targetUrl = function() {
        return eval(field.getAttribute("checkUrl"));
    };
    var url = targetUrl();

    var method = field.getAttribute("checkMethod");
    if (!method) method = "get";
	
    FormChecker.sendRequest(url, {
        method : method,
        onComplete : function(x) {
            targetValidationError.innerHTML = x.responseText;
        }
    });
}

function findFollowingSPAN(input, className) {
    var elem = input.nextSibling;
    while (elem.tagName != "SPAN" || elem.className != className)
        elem = elem.nextSibling;

    return elem;
}

function isDivErrorPresentInForm(myForm){
	var elems = myForm.getElementsByClassName("error");
	var divErrorPresent = false;
	var i=0;
	while(i<elems.length && !divErrorPresent){
		divErrorPresent = (elems[i].tagName == "DIV");
		i++;
	}
	return divErrorPresent;
}

// Hudson hack allowing to override the form.onsubmit generated by hudson-behaviour with
// a divError check
var myHudsonRules = {
	"FORM" : function(form){
        form.onsubmit = function() { return !isDivErrorPresentInForm(this); };
        form = null; // memory leak prevention
	}
};

function generateErrorMessage(message){
	// TODO: fix this "6d8c7ad0" absolute link !
	return "<div class=\"error\"><img src=\"/static/6d8c7ad0/images/none.gif\" height=\"16\" width=\"1\">"+message+"</div>";
}

Behaviour.register(Object.extend(hudsonRules, myHudsonRules));
Behaviour.apply();
