/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.global_build_stats.xstream.migration;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.plugins.global_build_stats.model.BuildStatConfiguration;
import hudson.plugins.global_build_stats.model.JobBuildResult;
import hudson.plugins.global_build_stats.model.ModelIdGenerator;
import hudson.plugins.global_build_stats.xstream.migration.GlobalBuildStatsDataMigrator;
import hudson.plugins.global_build_stats.xstream.migration.GlobalBuildStatsPOJO;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMigrator<TFROM extends GlobalBuildStatsPOJO, TTO extends GlobalBuildStatsPOJO>
implements GlobalBuildStatsDataMigrator<TFROM, TTO> {
    @Override
    public TTO migrate(TFROM pojo) {
        TTO migratedPojo = this.createMigratedPojo();
        migratedPojo.setBuildStatConfigs(this.migrateBuildStatConfigs(pojo.getBuildStatConfigs()));
        migratedPojo.setJobBuildResults(this.migrateJobBuildResults(pojo.getJobBuildResults()));
        return migratedPojo;
    }

    @Override
    public TTO readGlobalBuildStatsPOJO(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TTO pojo = this.createMigratedPojo();
        reader.moveDown();
        ArrayList<JobBuildResult> jobBuildResults = new ArrayList<JobBuildResult>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            JobBuildResult jbr = (JobBuildResult)context.convertAnother(pojo, JobBuildResult.class);
            jobBuildResults.add(jbr);
            reader.moveUp();
        }
        reader.moveUp();
        reader.moveDown();
        ArrayList<BuildStatConfiguration> buildStatConfigs = new ArrayList<BuildStatConfiguration>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            BuildStatConfiguration bsc = (BuildStatConfiguration)context.convertAnother(pojo, BuildStatConfiguration.class);
            buildStatConfigs.add(bsc);
            if (this.registerBuildStatConfigId()) {
                ModelIdGenerator.INSTANCE.registerIdForClass(BuildStatConfiguration.class, bsc.getId());
            }
            reader.moveUp();
        }
        reader.moveUp();
        pojo.setJobBuildResults(jobBuildResults);
        pojo.setBuildStatConfigs(buildStatConfigs);
        return pojo;
    }

    protected List<BuildStatConfiguration> migrateBuildStatConfigs(List<BuildStatConfiguration> buildStatConfigs) {
        return new ArrayList<BuildStatConfiguration>(buildStatConfigs);
    }

    protected List<JobBuildResult> migrateJobBuildResults(List<JobBuildResult> jobBuildResults) {
        return new ArrayList<JobBuildResult>(jobBuildResults);
    }

    protected boolean registerBuildStatConfigId() {
        return true;
    }

    protected static AbstractBuild retrieveBuildFromJobBuildResult(JobBuildResult jbr) {
        Job job = (Job)Hudson.getInstance().getItem(jbr.getJobName());
        if (job != null) {
            return (AbstractBuild)job.getBuildByNumber(jbr.getBuildNumber());
        }
        return null;
    }

    protected abstract TTO createMigratedPojo();
}

