/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.aunit;

import com.thalesgroup.hudson.plugins.gnat.aunit.AUnitParsing;
import com.thalesgroup.hudson.plugins.gnat.aunit.AUnitTestCase;
import com.thalesgroup.hudson.plugins.gnat.aunit.AUnitTestSuite;
import hudson.FilePath;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUnitParsing {
    private static final String PATTERN_LINE_TOTAL = "(\\s)+Total Tests Run: \\d";
    private static final String PATTERN_LINE_SUCCESSFUL_TESTS = "(\\s)+Successful Tests: \\d";
    private static final String PATTERN_LINE_FAILED_ASSERTIONS = "(\\s)+Failed Assertions: \\d";
    private static final String PATTERN_LINE_UNEPECTED_ERRORS = "(\\s)+Unexpected Errors: \\d";
    private static final String AUNIT_CLASS_WORLD = "class";
    private AUnitTestSuite suite = new AUnitTestSuite();

    private AUnitTestCase buildTestCaseInfo(String line) {
        String[] parts = line.split(":");
        String classStr = parts[0].trim();
        String className = classStr.substring(0, classStr.indexOf(AUNIT_CLASS_WORLD));
        className = className.trim();
        String methodname = parts[1].trim();
        TestCaseDTO vTestCaseDTO = new TestCaseDTO(this);
        vTestCaseDTO.classname = className;
        vTestCaseDTO.name = methodname;
        AUnitTestCase testCase = new AUnitTestCase();
        testCase.setClassname(vTestCaseDTO.classname);
        testCase.setName(vTestCaseDTO.name);
        return testCase;
    }

    private void processSuccessLines(int nbSucess, List<String> lines) {
        for (String line : lines) {
            this.suite.addTestCase(this.buildTestCaseInfo(line));
        }
    }

    private void processFailedLines(int nbFailed, List<String> lines) {
        this.suite.setNbFailure(nbFailed);
        AUnitTestCase testCase = null;
        Iterator<String> it = lines.iterator();
        while (it.hasNext()) {
            String line = it.next();
            testCase = this.buildTestCaseInfo(line);
            testCase.setFailed(true);
            if (it.hasNext()) {
                String nextLine = it.next();
                nextLine = nextLine.trim();
                testCase.setFailedMessage(nextLine);
                testCase.setFailedBody(nextLine);
            }
            this.suite.addTestCase(testCase);
        }
    }

    private void processErrorsLines(int nbErrors, List<String> lines) {
        this.suite.setNbErrors(nbErrors);
        AUnitTestCase testCase = null;
        Iterator<String> it = lines.iterator();
        while (it.hasNext()) {
            String line = it.next();
            testCase = this.buildTestCaseInfo(line);
            testCase.setError(true);
            if (it.hasNext()) {
                String nextLine = it.next();
                nextLine = nextLine.trim();
                testCase.setErrorMessage(nextLine);
                testCase.setErrorBody(nextLine);
            }
            this.suite.addTestCase(testCase);
        }
    }

    private int nbOfMainLine(String line) {
        Pattern p = Pattern.compile("\\d");
        Matcher m = p.matcher(line);
        if (m.find()) {
            return Integer.parseInt(m.group());
        }
        return 0;
    }

    public void process(FilePath junitOutputPath, String vAUnitExecLog, String executableProjTest) throws IOException {
        int nbSucess = 0;
        ArrayList<String> successLines = new ArrayList<String>();
        int nbFailed = 0;
        ArrayList<String> failedLines = new ArrayList<String>();
        int nbErrors = 0;
        ArrayList<String> errorsLines = new ArrayList<String>();
        boolean stopSuccessLines = false;
        boolean stopFailedLines = false;
        InputStreamReader source = new InputStreamReader(new ByteArrayInputStream(vAUnitExecLog.getBytes()));
        BufferedReader reader = new BufferedReader(source);
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("Time") || line.startsWith("-") || line.trim().length() == 0) continue;
            if (line.matches(PATTERN_LINE_TOTAL)) {
                this.suite.setNbTests(this.nbOfMainLine(line));
                continue;
            }
            if (line.matches(PATTERN_LINE_SUCCESSFUL_TESTS)) continue;
            if (line.matches(PATTERN_LINE_FAILED_ASSERTIONS)) {
                nbFailed = this.nbOfMainLine(line);
                stopSuccessLines = true;
                continue;
            }
            if (line.matches(PATTERN_LINE_UNEPECTED_ERRORS)) {
                nbErrors = this.nbOfMainLine(line);
                stopFailedLines = true;
                continue;
            }
            if (!stopSuccessLines) {
                successLines.add(line);
                continue;
            }
            if (!stopFailedLines) {
                failedLines.add(line);
                continue;
            }
            errorsLines.add(line);
        }
        reader.close();
        source.close();
        this.processSuccessLines(nbSucess, successLines);
        this.processFailedLines(nbFailed, failedLines);
        this.processErrorsLines(nbErrors, errorsLines);
        try {
            FilePath filePath = new FilePath(junitOutputPath, "TEST-" + executableProjTest.hashCode() + ".xml");
            FileOutputStream fw = new FileOutputStream(new File(filePath.toURI()));
            fw.write(this.suite.generateXML().getBytes());
            fw.close();
        }
        catch (Exception ioe) {
            System.out.println(ioe.toString());
        }
    }
}

