/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.aunit;

import com.thalesgroup.hudson.plugins.gnat.aunit.AUnitEntry;
import com.thalesgroup.hudson.plugins.gnat.aunit.AUnitParsing;
import com.thalesgroup.hudson.plugins.gnat.aunit.AUnitPublisher;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.Publisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AUnitPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Descriptor<Publisher> DESCRIPTOR = new AUnitPublisherDescriptor();
    private final List<AUnitEntry> executableListTestProj = new ArrayList();
    public static final String JUNIT_REPORTS_PATH = "temporary-junit-reports";

    public List<AUnitEntry> getExecutableListTestProj() {
        return this.executableListTestProj;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public Action getProjectAction(Project project) {
        TestResultProjectAction action = (TestResultProjectAction)project.getAction(TestResultProjectAction.class);
        if (action == null) {
            return new TestResultProjectAction((AbstractProject)project);
        }
        return null;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean result = true;
        if (build.getResult().equals(Result.SUCCESS) || build.getResult().equals(Result.UNSTABLE)) {
            Project proj = (Project)build.getProject();
            FilePath junitOutputPath = new FilePath(proj.getWorkspace(), JUNIT_REPORTS_PATH);
            junitOutputPath.mkdirs();
            for (AUnitEntry entry : this.executableListTestProj) {
                ArgumentListBuilder args = new ArgumentListBuilder();
                String normalizedExecutableProjTest = entry.executableTestProj.replaceAll("[\t\r\n]+", " ");
                normalizedExecutableProjTest = Util.replaceMacro((String)normalizedExecutableProjTest, (Map)build.getEnvVars());
                args.add(proj.getModuleRoot() + File.separator + normalizedExecutableProjTest);
                if (!launcher.isUnix()) {
                    args.prepend(new String[]{"cmd.exe", "/C"});
                    args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    int r = launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)baos, proj.getModuleRoot()).join();
                    if (r != 0) {
                        return false;
                    }
                    listener.getLogger().write(baos.toByteArray());
                    String vAUnitExecLog = baos.toString();
                    baos.close();
                    AUnitParsing vAUnitParsing = new AUnitParsing();
                    vAUnitParsing.process(junitOutputPath, vAUnitExecLog, normalizedExecutableProjTest);
                }
                catch (IOException e) {
                    Util.displayIOException((IOException)e, (TaskListener)listener);
                    e.printStackTrace(listener.fatalError("error"));
                    build.setResult(Result.FAILURE);
                    return false;
                }
            }
            result = this.recordTestResult("temporary-junit-reports/TEST-*.xml", build, listener);
            ((Project)build.getProject()).getWorkspace().child(JUNIT_REPORTS_PATH).deleteRecursive();
        }
        return result;
    }

    private TestResult getTestResult(String junitFilePattern, AbstractBuild<?, ?> build, TestResult existingTestResults, long buildTime) throws IOException, InterruptedException {
        TestResult result = (TestResult)build.getProject().getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private boolean recordTestResult(String junitFilePattern, AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = this.getTestResult(junitFilePattern, build, existingTestResults, buildTime);
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }
}

