/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.gnatcheck;

import com.thalesgroup.hudson.plugins.gnat.GnatInstallation;
import com.thalesgroup.hudson.plugins.gnat.gnatcheck.FreeStyleGnatcheckType;
import com.thalesgroup.hudson.plugins.gnat.gnatcheck.GnatcheckPublisher;
import com.thalesgroup.hudson.plugins.gnat.gnatcheck.GnatcheckType;
import com.thalesgroup.hudson.plugins.gnat.gnatcheck.ProjectGnatcheckType;
import com.thalesgroup.hudson.plugins.gnat.util.GnatException;
import com.thalesgroup.hudson.plugins.gnat.util.GnatUtil;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnatcheckPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final GnatcheckPublisherDescriptor DESCRIPTOR = new GnatcheckPublisherDescriptor();
    public final GnatcheckType[] types;

    public GnatcheckPublisher(GnatcheckType[] types) {
        this.types = types;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.SUCCESS) || build.getResult().equals(Result.UNSTABLE)) {
            Project proj = (Project)build.getProject();
            for (GnatcheckType type : this.types) {
                ArgumentListBuilder args = new ArgumentListBuilder();
                if (type instanceof ProjectGnatcheckType) {
                    ProjectGnatcheckType projectGnatcheckType = (ProjectGnatcheckType)type;
                    String execPathGnat = null;
                    try {
                        execPathGnat = GnatUtil.getExecutable((GnatInstallation[])projectGnatcheckType.getDescriptor().getInstallations(), (String)type.gnatName, (Launcher)launcher, (BuildListener)listener, (GnatInstallation.GNAT_TYPE)GnatInstallation.GNAT_TYPE.GNAT);
                    }
                    catch (GnatException ge) {
                        ge.printStackTrace(listener.fatalError("error"));
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                    args.add(execPathGnat);
                    args.add("check");
                    args.add("-P");
                    String normalizedProjectFile = projectGnatcheckType.projectFile.replaceAll("[\t\r\n]+", " ");
                    GnatUtil.addTokenIfExist((String)(proj.getModuleRoot() + File.separator + normalizedProjectFile), (ArgumentListBuilder)args, (boolean)true, build, (String[])new String[0]);
                    GnatUtil.addTokenIfExist((String)projectGnatcheckType.options, (ArgumentListBuilder)args, (boolean)false, build, (String[])new String[0]);
                    GnatUtil.addTokenIfExist((String)projectGnatcheckType.rule_options, (ArgumentListBuilder)args, (boolean)false, build, (String[])new String[]{"-rules"});
                } else {
                    FreeStyleGnatcheckType freeStyleGnatcheckType = (FreeStyleGnatcheckType)type;
                    String execPathGnatcheck = null;
                    try {
                        execPathGnatcheck = GnatUtil.getExecutable((GnatInstallation[])freeStyleGnatcheckType.getDescriptor().getInstallations(), (String)type.gnatName, (Launcher)launcher, (BuildListener)listener, (GnatInstallation.GNAT_TYPE)GnatInstallation.GNAT_TYPE.GNATCHECK);
                    }
                    catch (GnatException ge) {
                        ge.printStackTrace(listener.fatalError("error"));
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                    args.add(execPathGnatcheck);
                    GnatUtil.addTokenIfExist((String)freeStyleGnatcheckType.switches, (ArgumentListBuilder)args, (boolean)false, build, (String[])new String[0]);
                    GnatUtil.addTokenIfExist((String)freeStyleGnatcheckType.filename, (ArgumentListBuilder)args, (boolean)true, build, (String[])new String[0]);
                    GnatUtil.addTokenIfExist((String)freeStyleGnatcheckType.gcc_switches, (ArgumentListBuilder)args, (boolean)false, build, (String[])new String[]{"-cargs"});
                    GnatUtil.addTokenIfExist((String)freeStyleGnatcheckType.rule_options, (ArgumentListBuilder)args, (boolean)false, build, (String[])new String[]{"-rules"});
                }
                try {
                    int r = launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)listener.getLogger(), proj.getModuleRoot()).join();
                    if (r == 0) continue;
                    build.setResult(Result.FAILURE);
                    return false;
                }
                catch (IOException e) {
                    Util.displayIOException((IOException)e, (TaskListener)listener);
                    e.printStackTrace(listener.fatalError("error"));
                    build.setResult(Result.FAILURE);
                    return false;
                }
            }
        }
        return true;
    }
}

