/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.aunit;

import com.thalesgroup.hudson.plugins.gnat.aunit.AUnitTestCase;
import java.util.ArrayList;
import java.util.List;

public class AUnitTestSuite {
    private int nbErrors;
    private int nbFailure;
    private int nbTests;
    private String name;
    private List<AUnitTestCase> testcases = new ArrayList<AUnitTestCase>();

    public void addTestCase(AUnitTestCase testcase) {
        this.testcases.add(testcase);
    }

    public int getNbErrors() {
        return this.nbErrors;
    }

    public void setNbErrors(int nbErrors) {
        this.nbErrors = nbErrors;
    }

    public int getNbFailure() {
        return this.nbFailure;
    }

    public void setNbFailure(int nbFailure) {
        this.nbFailure = nbFailure;
    }

    public int getNbTests() {
        return this.nbTests;
    }

    public void setNbTests(int nbTests) {
        this.nbTests = nbTests;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String generateXML() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<testsuite errors=\"").append(this.nbErrors).append("\" failures=\"").append(this.nbFailure).append("\" tests=\"").append(this.nbTests).append("\" name=\"\">\n");
        for (AUnitTestCase testcase : this.testcases) {
            builder.append("<testcase classname=\"").append(testcase.getClassname()).append("\" name=\"").append(testcase.getName()).append("\" time=\"").append(testcase.getTime()).append("\">\n");
            if (testcase.isFailed()) {
                builder.append("<failure message=\"").append(testcase.getFailedMessage()).append("\">");
                if (testcase.getFailedBody() != null) {
                    builder.append(testcase.getFailedBody());
                }
                builder.append("</failure>\n");
            }
            if (testcase.isError()) {
                builder.append("<error message=\"").append(testcase.getErrorMessage()).append("\">");
                if (testcase.getErrorBody() != null) {
                    builder.append(testcase.getErrorBody());
                }
                builder.append("</error>\n");
            }
            builder.append("</testcase>\n");
        }
        builder.append("</testsuite>");
        return builder.toString();
    }
}

