/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.gnathtml;

import com.thalesgroup.hudson.plugins.gnat.GnatInstallation;
import com.thalesgroup.hudson.plugins.gnat.gnatmake.GnatmakeBuilder;
import com.thalesgroup.hudson.plugins.gnat.util.GnatException;
import com.thalesgroup.hudson.plugins.gnat.util.GnatUtil;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.FreeStyleProject;
import hudson.model.ModelObject;
import hudson.model.Project;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnathtmlArchiver
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String GNATHTML_DEFAULT_GENERATED_DIRECTORY = "html";
    private static final String GNATHTML_GENERATED_DIRECTORY_OTION = "-o";
    public static final GnathtmlArchiverDescriptor DESCRIPTOR = new GnathtmlArchiverDescriptor();
    private final String gnatName;
    private final String switches;
    private final String adafiles;
    private final boolean keepAll;

    public String getSwitches() {
        return this.switches;
    }

    public String getAdafiles() {
        return this.adafiles;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    public String getGnatName() {
        return this.gnatName;
    }

    @DataBoundConstructor
    public GnathtmlArchiver(String gnatName, String switches, String adafiles, boolean keepAll) {
        this.gnatName = gnatName;
        this.switches = switches;
        this.adafiles = adafiles;
        this.keepAll = keepAll;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    private FilePath getGnathtmlGeneratedDir(AbstractBuild<?, ?> build) throws InterruptedException {
        String generatedDir = GNATHTML_DEFAULT_GENERATED_DIRECTORY;
        Pattern p = Pattern.compile("[\\s]+");
        String[] result = p.split(this.switches);
        for (int i = 0; i < result.length; ++i) {
            if (!GNATHTML_GENERATED_DIRECTORY_OTION.equals(result[i]) || i + 1 > result.length - 1) continue;
            return ((AbstractProject)build.getParent()).getModuleRoot().child(result[i + 1]);
        }
        return ((AbstractProject)build.getParent()).getModuleRoot().child(generatedDir);
    }

    private static File getGnathtmlDir(AbstractItem project) {
        return new File(project.getRootDir(), "gnathtml");
    }

    private static File getGnathtmlDir(Run run) {
        return new File(run.getRootDir(), "gnathtml");
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Project proj = (Project)build.getProject();
        String execPathGnathtml = null;
        try {
            execPathGnathtml = GnatUtil.getExecutable(DESCRIPTOR.getInstallations(), this.gnatName, launcher, listener, GnatInstallation.GNAT_TYPE.GNATHTML);
        }
        catch (GnatException ge) {
            ge.printStackTrace(listener.fatalError("error"));
            build.setResult(Result.FAILURE);
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(execPathGnathtml);
        GnatUtil.addTokenIfExist(this.switches, args, false, build, new String[0]);
        GnatUtil.addTokenIfExist(this.adafiles, args, true, build, new String[0]);
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)listener.getLogger(), proj.getModuleRoot()).join();
            if (r != 0) {
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("error"));
            build.setResult(Result.FAILURE);
            return false;
        }
        FilePath gnathtmlGenerateDir = this.getGnathtmlGeneratedDir((AbstractBuild<?, ?>)build);
        FilePath target = new FilePath(this.keepAll ? GnathtmlArchiver.getGnathtmlDir(build) : GnathtmlArchiver.getGnathtmlDir((AbstractItem)build.getProject()));
        try {
            if (gnathtmlGenerateDir.copyRecursiveTo("**/*", target) == 0) {
                if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                    // empty if block
                }
                build.setResult(Result.FAILURE);
                return true;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("error"));
            build.setResult(Result.FAILURE);
            return true;
        }
        FilePath originIndex = new FilePath(target, "index.htm");
        originIndex.renameTo(new FilePath(target, "index.html"));
        if (this.keepAll) {
            build.addAction((Action)new GnathtmlBuildAction((AbstractBuild<?, ?>)build));
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(Project project) {
        return new GnathtmlAction((AbstractItem)project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GnathtmlBuildAction
    extends BaseGnathtmlAction {
        private final AbstractBuild<?, ?> build;

        public GnathtmlBuildAction(AbstractBuild<?, ?> build) {
            this.build = build;
        }

        @Override
        protected String getTitle() {
            return this.build.getDisplayName() + " gnathtml";
        }

        @Override
        protected File dir() {
            return new File(this.build.getRootDir(), "gnathtml");
        }
    }

    public static class GnathtmlAction
    extends BaseGnathtmlAction
    implements ProminentProjectAction {
        private final AbstractItem project;

        public GnathtmlAction(AbstractItem project) {
            this.project = project;
        }

        protected File dir() {
            File gnathtmlDir;
            AbstractProject abstractProject;
            Run run;
            if (this.project instanceof AbstractProject && (run = (abstractProject = (AbstractProject)this.project).getLastSuccessfulBuild()) != null && (gnathtmlDir = GnathtmlArchiver.getGnathtmlDir(run)).exists()) {
                return gnathtmlDir;
            }
            return GnathtmlArchiver.getGnathtmlDir(this.project);
        }

        protected String getTitle() {
            return this.project.getDisplayName() + " gnathtml";
        }
    }

    protected static abstract class BaseGnathtmlAction
    implements Action {
        protected BaseGnathtmlAction() {
        }

        public String getUrlName() {
            return "gnathtml";
        }

        public String getDisplayName() {
            return "Gnat HTML";
        }

        public String getIconFileName() {
            if (this.dir().exists()) {
                return "help.gif";
            }
            return null;
        }

        public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            new DirectoryBrowserSupport((ModelObject)this, this.getTitle()).serveFile(req, rsp, new FilePath(this.dir()), "help.gif", false);
        }

        protected abstract String getTitle();

        protected abstract File dir();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GnathtmlArchiverDescriptor
    extends Descriptor<Publisher> {
        public GnathtmlArchiverDescriptor() {
            super(GnathtmlArchiver.class);
        }

        public String getDisplayName() {
            return "Publish gnathtml reports";
        }

        public GnathtmlArchiver newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            GnathtmlArchiver p = new GnathtmlArchiver(req.getParameter("gnathtml.gnatName"), req.getParameter("gnathtml.switches"), req.getParameter("gnathtml.adafiles"), req.getParameter("gnathtml.keepall") != null);
            return p;
        }

        public String getHelpFile() {
            return "/plugin/gnat/gnathtml/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType);
        }

        public GnatInstallation[] getInstallations() {
            return GnatmakeBuilder.DESCRIPTOR.getInstallations();
        }
    }
}

