/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.gnatmake;

import com.thalesgroup.hudson.plugins.gnat.GnatInstallation;
import com.thalesgroup.hudson.plugins.gnat.util.GnatException;
import com.thalesgroup.hudson.plugins.gnat.util.GnatUtil;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnatmakeBuilder
extends Builder {
    private final String gnatName;
    private final String switches;
    private final String fileNames;
    private final String modeSwitches;
    public static final GnatmakeBuilderDescriptor DESCRIPTOR = new GnatmakeBuilderDescriptor();

    public String getSwitches() {
        return this.switches;
    }

    @DataBoundConstructor
    public GnatmakeBuilder(String gnatName, String switches, String fileNames, String modeSwitches) {
        this.gnatName = gnatName;
        this.switches = switches;
        this.fileNames = fileNames;
        this.modeSwitches = modeSwitches;
    }

    public String getFileNames() {
        return this.fileNames;
    }

    public String getModeSwitches() {
        return this.modeSwitches;
    }

    public String getGnatName() {
        return this.gnatName;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Project proj = (Project)build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execPathGnatmake = null;
        try {
            execPathGnatmake = GnatUtil.getExecutable(DESCRIPTOR.getInstallations(), this.gnatName, launcher, listener, GnatInstallation.GNAT_TYPE.GNATMAKE);
            args.add(execPathGnatmake);
        }
        catch (GnatException ge) {
            ge.printStackTrace(listener.fatalError("error"));
            build.setResult(Result.FAILURE);
            return false;
        }
        String normalizedSwitches = this.switches.replaceAll("[\t\r\n]+", " ");
        String normalizedFileNames = this.fileNames.replaceAll("[\t\r\n]+", " ");
        String normalizedModeSwitches = this.modeSwitches.replaceAll("[\t\r\n]+", " ");
        if (normalizedSwitches != null && normalizedSwitches.trim().length() != 0) {
            args.addTokenized(normalizedSwitches);
        }
        if (normalizedFileNames == null || normalizedFileNames.trim().length() == 0) {
            listener.fatalError("The GNAT file_name field is mandatory.");
            return false;
        }
        args.addTokenized(normalizedFileNames);
        if (normalizedModeSwitches != null && normalizedModeSwitches.trim().length() != 0) {
            args.addTokenized(normalizedModeSwitches);
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)listener.getLogger(), proj.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GnatmakeBuilderDescriptor
    extends Descriptor<Builder> {
        private volatile GnatInstallation[] installations = new GnatInstallation[0];

        private GnatmakeBuilderDescriptor() {
            super(GnatmakeBuilder.class);
            this.load();
        }

        public String getHelpFile() {
            return "/plugin/gnat/gnatmake/help.html";
        }

        public String getDisplayName() {
            return "Invoke gnatmake script";
        }

        public GnatInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req) {
            this.installations = req.bindParametersToList(GnatInstallation.class, "gnat.").toArray(new GnatInstallation[0]);
            this.save();
            return true;
        }

        public void doCheckGnatmakeHome(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                public void check() throws IOException, ServletException {
                    File f = this.getFileParameter("value");
                    if (!f.isDirectory()) {
                        this.error(f + " is not a directory");
                        return;
                    }
                    if (!new File(f, "bin").exists() && !new File(f, "lib").exists()) {
                        this.error(f + " doesn't look like a GNAT installation directory");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }
    }
}

