/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.gnatmetric;

import com.thalesgroup.hudson.plugins.gnat.GnatInstallation;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.FreeStyleGnatmetricType;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.GnatmetricType;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.GnatmetricTypeDescriptor;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.ProjectGnatmetricType;
import com.thalesgroup.hudson.plugins.gnat.util.GnatException;
import com.thalesgroup.hudson.plugins.gnat.util.GnatUtil;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.Publisher;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnatmetricPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final GnatmetricType[] types;
    public static final GnatmetricPublisherDescriptor DESCRIPTOR = new GnatmetricPublisherDescriptor();

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public GnatmetricPublisher(GnatmetricType[] types) {
        this.types = types;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.SUCCESS) || build.getResult().equals(Result.UNSTABLE)) {
            Project proj = (Project)build.getProject();
            for (GnatmetricType type : this.types) {
                ArgumentListBuilder args = new ArgumentListBuilder();
                if (type instanceof ProjectGnatmetricType) {
                    ProjectGnatmetricType projectGnatMetricType = (ProjectGnatmetricType)type;
                    String execPathGnat = null;
                    try {
                        execPathGnat = GnatUtil.getExecutable(projectGnatMetricType.getDescriptor().getInstallations(), type.gnatName, launcher, listener, GnatInstallation.GNAT_TYPE.GNAT);
                    }
                    catch (GnatException ge) {
                        ge.printStackTrace(listener.fatalError("error"));
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                    args.add(execPathGnat);
                    args.add("metric");
                    args.add("-P");
                    String normalizedProjectFile = projectGnatMetricType.projectFile.replaceAll("[\t\r\n]+", " ");
                    GnatUtil.addTokenIfExist(proj.getModuleRoot() + File.separator + normalizedProjectFile, args, true, build, new String[0]);
                    GnatUtil.addTokenIfExist(projectGnatMetricType.options, args, false, build, new String[0]);
                } else {
                    FreeStyleGnatmetricType freeStyleGnatMetricType = (FreeStyleGnatmetricType)type;
                    String execPathGnatmetric = null;
                    try {
                        execPathGnatmetric = GnatUtil.getExecutable(freeStyleGnatMetricType.getDescriptor().getInstallations(), type.gnatName, launcher, listener, GnatInstallation.GNAT_TYPE.GNATMETRIC);
                    }
                    catch (GnatException ge) {
                        ge.printStackTrace(listener.fatalError("error"));
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                    args.add(execPathGnatmetric);
                    GnatUtil.addTokenIfExist(freeStyleGnatMetricType.switches, args, false, build, new String[0]);
                    GnatUtil.addTokenIfExist(freeStyleGnatMetricType.filename, args, false, build, new String[0]);
                    GnatUtil.addTokenIfExist(freeStyleGnatMetricType.gcc_switches, args, false, build, new String[]{"-cargs"});
                }
                if (!launcher.isUnix()) {
                    args.prepend(new String[]{"cmd.exe", "/C"});
                    args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
                }
                try {
                    int r = launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)listener.getLogger(), proj.getModuleRoot()).join();
                    if (r == 0) continue;
                    build.setResult(Result.FAILURE);
                    return false;
                }
                catch (IOException e) {
                    Util.displayIOException((IOException)e, (TaskListener)listener);
                    e.printStackTrace(listener.fatalError("error"));
                    build.setResult(Result.FAILURE);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GnatmetricPublisherDescriptor
    extends Descriptor<Publisher> {
        public GnatmetricPublisherDescriptor() {
            super(GnatmetricPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Run gnatmetric";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List buildTypes = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"types", GnatmetricTypeDescriptor.LIST);
            return new GnatmetricPublisher(buildTypes.toArray(new GnatmetricType[buildTypes.size()]));
        }

        public List<GnatmetricTypeDescriptor> getBuildTypes() {
            return GnatmetricTypeDescriptor.LIST;
        }

        public String getHelpFile() {
            return "/plugin/gnat/gnatmetric/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType);
        }
    }
}

