/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.gnatmetric;

import com.thalesgroup.hudson.plugins.gnat.GnatInstallation;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.FreeStyleGnatmetricType;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.GnatmetricType;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.ProjectGnatmetricType;
import com.thalesgroup.hudson.plugins.gnat.util.GnatException;
import com.thalesgroup.hudson.plugins.gnat.util.GnatUtil;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnatmetricPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final GnatmetricType[] types;

    public GnatmetricPublisher(GnatmetricType[] types) {
        this.types = types;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.SUCCESS) || build.getResult().equals(Result.UNSTABLE)) {
            for (GnatmetricType type : this.types) {
                ArgumentListBuilder args = new ArgumentListBuilder();
                if (type instanceof ProjectGnatmetricType) {
                    ProjectGnatmetricType projectGnatMetricType = (ProjectGnatmetricType)type;
                    String execPathGnat = null;
                    try {
                        execPathGnat = GnatUtil.getExecutable((GnatInstallation[])projectGnatMetricType.getDescriptor().getInstallations(), (String)type.gnatName, (Launcher)launcher, (BuildListener)listener, (GnatInstallation.GNAT_TYPE)GnatInstallation.GNAT_TYPE.GNAT);
                    }
                    catch (GnatException ge) {
                        ge.printStackTrace(listener.fatalError("error"));
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                    args.add(execPathGnat);
                    args.add("metric");
                    args.add("-P");
                    String normalizedProjectFile = projectGnatMetricType.projectFile.replaceAll("[\t\r\n]+", " ");
                    GnatUtil.addTokenIfExist((String)(build.getModuleRoot() + File.separator + normalizedProjectFile), (ArgumentListBuilder)args, (boolean)true, build, (String[])new String[0]);
                    GnatUtil.addTokenIfExist((String)projectGnatMetricType.options, (ArgumentListBuilder)args, (boolean)false, build, (String[])new String[0]);
                } else {
                    FreeStyleGnatmetricType freeStyleGnatMetricType = (FreeStyleGnatmetricType)type;
                    String execPathGnatmetric = null;
                    try {
                        execPathGnatmetric = GnatUtil.getExecutable((GnatInstallation[])freeStyleGnatMetricType.getDescriptor().getInstallations(), (String)type.gnatName, (Launcher)launcher, (BuildListener)listener, (GnatInstallation.GNAT_TYPE)GnatInstallation.GNAT_TYPE.GNATMETRIC);
                    }
                    catch (GnatException ge) {
                        ge.printStackTrace(listener.fatalError("error"));
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                    args.add(execPathGnatmetric);
                    GnatUtil.addTokenIfExist((String)freeStyleGnatMetricType.switches, (ArgumentListBuilder)args, (boolean)false, build, (String[])new String[0]);
                    GnatUtil.addTokenIfExist((String)freeStyleGnatMetricType.filename, (ArgumentListBuilder)args, (boolean)false, build, (String[])new String[0]);
                    GnatUtil.addTokenIfExist((String)freeStyleGnatMetricType.gcc_switches, (ArgumentListBuilder)args, (boolean)false, build, (String[])new String[]{"-cargs"});
                }
                if (!launcher.isUnix()) {
                    args.prepend(new String[]{"cmd.exe", "/C"});
                    args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
                }
                try {
                    int r = launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
                    if (r == 0) continue;
                    build.setResult(Result.FAILURE);
                    return false;
                }
                catch (IOException e) {
                    Util.displayIOException((IOException)e, (TaskListener)listener);
                    e.printStackTrace(listener.fatalError("error"));
                    build.setResult(Result.FAILURE);
                    return false;
                }
            }
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }
}

