/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.gnatcheck;

import com.thalesgroup.hudson.plugins.gnat.GnatInstallation;
import com.thalesgroup.hudson.plugins.gnat.gnatcheck.FreeStyleGnatcheckType;
import com.thalesgroup.hudson.plugins.gnat.gnatcheck.GnatcheckType;
import com.thalesgroup.hudson.plugins.gnat.gnatcheck.GnatcheckTypeDescriptor;
import com.thalesgroup.hudson.plugins.gnat.gnatcheck.ProjectGnatcheckType;
import com.thalesgroup.hudson.plugins.gnat.gnatmake.GnatmakeBuilder;
import com.thalesgroup.hudson.plugins.gnat.util.GnatException;
import com.thalesgroup.hudson.plugins.gnat.util.GnatUtil;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnatcheckPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final GnatcheckType[] types;

    public GnatcheckPublisher(GnatcheckType[] types) {
        this.types = types;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.SUCCESS) || build.getResult().equals(Result.UNSTABLE)) {
            for (GnatcheckType type : this.types) {
                ArgumentListBuilder args = new ArgumentListBuilder();
                if (type instanceof ProjectGnatcheckType) {
                    ProjectGnatcheckType projectGnatcheckType = (ProjectGnatcheckType)type;
                    String execPathGnat = null;
                    try {
                        execPathGnat = GnatUtil.getExecutable(projectGnatcheckType.getDescriptor().getInstallations(), type.gnatName, launcher, listener, GnatInstallation.GNAT_TYPE.GNAT);
                    }
                    catch (GnatException ge) {
                        ge.printStackTrace(listener.fatalError("error"));
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                    args.add(execPathGnat);
                    args.add("check");
                    args.add("-P");
                    String normalizedProjectFile = projectGnatcheckType.projectFile.replaceAll("[\t\r\n]+", " ");
                    GnatUtil.addTokenIfExist(build.getModuleRoot() + File.separator + normalizedProjectFile, args, true, build, new String[0]);
                    GnatUtil.addTokenIfExist(projectGnatcheckType.options, args, false, build, new String[0]);
                    GnatUtil.addTokenIfExist(projectGnatcheckType.rule_options, args, false, build, "-rules");
                } else {
                    FreeStyleGnatcheckType freeStyleGnatcheckType = (FreeStyleGnatcheckType)type;
                    String execPathGnatcheck = null;
                    try {
                        execPathGnatcheck = GnatUtil.getExecutable(freeStyleGnatcheckType.getDescriptor().getInstallations(), type.gnatName, launcher, listener, GnatInstallation.GNAT_TYPE.GNATCHECK);
                    }
                    catch (GnatException ge) {
                        ge.printStackTrace(listener.fatalError("error"));
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                    args.add(execPathGnatcheck);
                    GnatUtil.addTokenIfExist(freeStyleGnatcheckType.switches, args, false, build, new String[0]);
                    GnatUtil.addTokenIfExist(freeStyleGnatcheckType.filename, args, true, build, new String[0]);
                    GnatUtil.addTokenIfExist(freeStyleGnatcheckType.gcc_switches, args, false, build, "-cargs");
                    GnatUtil.addTokenIfExist(freeStyleGnatcheckType.rule_options, args, false, build, "-rules");
                }
                try {
                    int r = launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
                    if (r == 0) continue;
                    build.setResult(Result.FAILURE);
                    return false;
                }
                catch (IOException e) {
                    Util.displayIOException((IOException)e, (TaskListener)listener);
                    e.printStackTrace(listener.fatalError("error"));
                    build.setResult(Result.FAILURE);
                    return false;
                }
            }
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GnatcheckPublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        public GnatcheckPublisherDescriptor() {
            super(GnatcheckPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Run gnatcheck";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List buildTypes = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"types", GnatcheckTypeDescriptor.LIST);
            return new GnatcheckPublisher(buildTypes.toArray(new GnatcheckType[buildTypes.size()]));
        }

        public String getHelpFile() {
            return "/plugin/gnat/gnatcheck/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType);
        }

        public GnatInstallation[] getInstallations() {
            return GnatmakeBuilder.DESCRIPTOR.getInstallations();
        }

        public List<GnatcheckTypeDescriptor> getBuildTypes() {
            return GnatcheckTypeDescriptor.LIST;
        }
    }
}

