/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.util;

import com.thalesgroup.hudson.plugins.gnat.GnatInstallation;
import com.thalesgroup.hudson.plugins.gnat.util.GnatException;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnatUtil {
    public static String getExecutable(GnatInstallation[] installations, String selectGnatLogicalName, Launcher launcher, BuildListener listener, GnatInstallation.GNAT_TYPE gnatType) throws GnatException {
        String execPath = null;
        GnatInstallation ai = GnatUtil.getGnatlogicalName(installations, selectGnatLogicalName);
        if (ai == null) {
            execPath = gnatType.getExecName(launcher.isUnix());
        } else {
            File exec = ai.getExecutable(gnatType);
            if (!ai.getExists()) {
                listener.fatalError(exec + " doesn't exist");
                throw new GnatException();
            }
            execPath = exec.getPath();
        }
        return execPath;
    }

    public static void addTokenIfExist(String token, ArgumentListBuilder args, boolean replaceMacro, AbstractBuild<?, ?> build, String ... beforeArgs) throws IOException, InterruptedException {
        String normalizedToken = token.replaceAll("[\t\r\n]+", " ");
        if (replaceMacro) {
            normalizedToken = Util.replaceMacro((String)normalizedToken, (Map)build.getEnvironment(TaskListener.NULL));
        }
        if (normalizedToken != null && normalizedToken.trim().length() != 0) {
            for (String arg : beforeArgs) {
                args.add(arg);
            }
            args.addTokenized(normalizedToken);
        }
    }

    private static GnatInstallation getGnatlogicalName(GnatInstallation[] installations, String selectGnatLogicalName) {
        for (GnatInstallation i : installations) {
            if (selectGnatLogicalName == null || !i.getName().equals(selectGnatLogicalName)) continue;
            return i;
        }
        return null;
    }
}

