/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.gnathtml;

import com.thalesgroup.hudson.plugins.gnat.GnatInstallation;
import com.thalesgroup.hudson.plugins.gnat.gnathtml.GnathtmlArchiver;
import com.thalesgroup.hudson.plugins.gnat.util.GnatException;
import com.thalesgroup.hudson.plugins.gnat.util.GnatUtil;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GnathtmlArchiver
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String GNATHTML_DEFAULT_GENERATED_DIRECTORY = "html";
    private static final String GNATHTML_GENERATED_DIRECTORY_OTION = "-o";
    @Extension
    public static final GnathtmlArchiverDescriptor DESCRIPTOR = new GnathtmlArchiverDescriptor();
    private final String gnatName;
    private final String switches;
    private final String adafiles;
    private final boolean keepAll;

    public String getSwitches() {
        return this.switches;
    }

    public String getAdafiles() {
        return this.adafiles;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    public String getGnatName() {
        return this.gnatName;
    }

    @DataBoundConstructor
    public GnathtmlArchiver(String gnatName, String switches, String adafiles, boolean keepAll) {
        this.gnatName = gnatName;
        this.switches = switches;
        this.adafiles = adafiles;
        this.keepAll = keepAll;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    private FilePath getGnathtmlGeneratedDir(AbstractBuild<?, ?> build) throws InterruptedException {
        String generatedDir = "html";
        Pattern p = Pattern.compile("[\\s]+");
        String[] result = p.split(this.switches);
        for (int i = 0; i < result.length; ++i) {
            if (!"-o".equals(result[i]) || i + 1 > result.length - 1) continue;
            return build.getModuleRoot().child(result[i + 1]);
        }
        return build.getModuleRoot().child(generatedDir);
    }

    private static File getGnathtmlDir(AbstractItem project) {
        return new File(project.getRootDir(), "gnathtml");
    }

    private static File getGnathtmlDir(Run run) {
        return new File(run.getRootDir(), "gnathtml");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String execPathGnathtml = null;
        try {
            execPathGnathtml = GnatUtil.getExecutable((GnatInstallation[])DESCRIPTOR.getInstallations(), (String)this.gnatName, (Launcher)launcher, (BuildListener)listener, (GnatInstallation.GNAT_TYPE)GnatInstallation.GNAT_TYPE.GNATHTML);
        }
        catch (GnatException ge) {
            ge.printStackTrace(listener.fatalError("error"));
            build.setResult(Result.FAILURE);
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(execPathGnathtml);
        GnatUtil.addTokenIfExist((String)this.switches, (ArgumentListBuilder)args, (boolean)false, build, (String[])new String[0]);
        GnatUtil.addTokenIfExist((String)this.adafiles, (ArgumentListBuilder)args, (boolean)true, build, (String[])new String[0]);
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
            if (r != 0) {
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("error"));
            build.setResult(Result.FAILURE);
            return false;
        }
        FilePath gnathtmlGenerateDir = this.getGnathtmlGeneratedDir(build);
        FilePath target = new FilePath(this.keepAll ? GnathtmlArchiver.getGnathtmlDir(build) : GnathtmlArchiver.getGnathtmlDir((AbstractItem)build.getProject()));
        try {
            if (gnathtmlGenerateDir.copyRecursiveTo("**/*", target) == 0) {
                if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                    // empty if block
                }
                build.setResult(Result.FAILURE);
                return true;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("error"));
            build.setResult(Result.FAILURE);
            return true;
        }
        FilePath originIndex = new FilePath(target, "index.htm");
        originIndex.renameTo(new FilePath(target, "index.html"));
        if (this.keepAll) {
            build.addAction((Action)new GnathtmlBuildAction(build));
        }
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new GnathtmlAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    static /* synthetic */ File access$000(Run x0) {
        return GnathtmlArchiver.getGnathtmlDir((Run)x0);
    }

    static /* synthetic */ File access$100(AbstractItem x0) {
        return GnathtmlArchiver.getGnathtmlDir((AbstractItem)x0);
    }
}

