/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat;

import java.io.File;
import org.kohsuke.stapler.DataBoundConstructor;

public final class GnatInstallation {
    private final String name;
    private final String gnatmakeHome;

    @DataBoundConstructor
    public GnatInstallation(String name, String home) {
        this.name = name;
        this.gnatmakeHome = home;
    }

    public String getGnatmakeHome() {
        return this.gnatmakeHome;
    }

    public String getName() {
        return this.name;
    }

    public File getExecutable(GNAT_TYPE gnattype) {
        String execName = File.separatorChar == '\\' ? gnattype.getExecName(false) : gnattype.getExecName(true);
        return new File(this.getGnatmakeHome(), "bin/" + execName);
    }

    public boolean getExists() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GNAT_TYPE {
        GNAT("gnat", false),
        GNATMAKE("gnatmake", false),
        GNATMETRIC("gnatmetric", false),
        GNATCHECK("gnatcheck", false),
        GNATHTML("gnathtml", true);

        private final String execName;
        private final boolean perl;

        private GNAT_TYPE(String execName, boolean perl) {
            this.execName = execName;
            this.perl = perl;
        }

        public String getExecName(boolean isUnix) {
            if (this.perl) {
                return this.execName + ".pl";
            }
            if (!isUnix) {
                return this.execName + ".exe";
            }
            return this.execName;
        }
    }
}

