/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.gnat.gnatmetric;

import com.thalesgroup.hudson.plugins.gnat.GnatInstallation;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.FreeStyleGnatmetricType;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.GnatmetricType;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.GnatmetricTypeDescriptor;
import com.thalesgroup.hudson.plugins.gnat.gnatmetric.ProjectGnatmetricType;
import com.thalesgroup.hudson.plugins.gnat.util.GnatException;
import com.thalesgroup.hudson.plugins.gnat.util.GnatUtil;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnatmetricPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final GnatmetricType[] types;

    public GnatmetricPublisher(GnatmetricType[] types) {
        this.types = types;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.SUCCESS) || build.getResult().equals(Result.UNSTABLE)) {
            for (GnatmetricType type : this.types) {
                ArgumentListBuilder args = new ArgumentListBuilder();
                if (type instanceof ProjectGnatmetricType) {
                    String execPathGnat;
                    ProjectGnatmetricType projectGnatMetricType = (ProjectGnatmetricType)type;
                    try {
                        execPathGnat = GnatUtil.getExecutable(projectGnatMetricType.getDescriptor().getInstallations(), type.gnatName, launcher, listener, GnatInstallation.GNAT_TYPE.GNAT);
                    }
                    catch (GnatException ge) {
                        ge.printStackTrace(listener.fatalError("error"));
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                    args.add(execPathGnat);
                    args.add("metric");
                    args.add("-P");
                    String normalizedProjectFile = projectGnatMetricType.projectFile.replaceAll("[\t\r\n]+", " ");
                    GnatUtil.addTokenIfExist(build.getModuleRoot() + File.separator + normalizedProjectFile, args, true, build, new String[0]);
                    GnatUtil.addTokenIfExist(projectGnatMetricType.options, args, false, build, new String[0]);
                } else {
                    String execPathGnatmetric;
                    FreeStyleGnatmetricType freeStyleGnatMetricType = (FreeStyleGnatmetricType)type;
                    try {
                        execPathGnatmetric = GnatUtil.getExecutable(freeStyleGnatMetricType.getDescriptor().getInstallations(), type.gnatName, launcher, listener, GnatInstallation.GNAT_TYPE.GNATMETRIC);
                    }
                    catch (GnatException ge) {
                        ge.printStackTrace(listener.fatalError("error"));
                        build.setResult(Result.FAILURE);
                        return false;
                    }
                    args.add(execPathGnatmetric);
                    GnatUtil.addTokenIfExist(freeStyleGnatMetricType.switches, args, false, build, new String[0]);
                    GnatUtil.addTokenIfExist(freeStyleGnatMetricType.filename, args, false, build, new String[0]);
                    GnatUtil.addTokenIfExist(freeStyleGnatMetricType.gcc_switches, args, false, build, "-cargs");
                }
                if (!launcher.isUnix()) {
                    args.prepend(new String[]{"cmd.exe", "/C"});
                    args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
                }
                try {
                    int r = launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
                    if (r == 0) continue;
                    build.setResult(Result.FAILURE);
                    return false;
                }
                catch (IOException e) {
                    Util.displayIOException((IOException)e, (TaskListener)listener);
                    e.printStackTrace(listener.fatalError("error"));
                    build.setResult(Result.FAILURE);
                    return false;
                }
            }
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class GnatmetricPublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        public GnatmetricPublisherDescriptor() {
            super(GnatmetricPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Run gnatmetric";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List buildTypes = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"types", this.getBuildTypes());
            return new GnatmetricPublisher(buildTypes.toArray(new GnatmetricType[buildTypes.size()]));
        }

        public List<GnatmetricTypeDescriptor> getBuildTypes() {
            return Hudson.getInstance().getDescriptorList(GnatmetricType.class);
        }

        public String getHelpFile() {
            return "/plugin/gnat/gnatmetric/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType);
        }
    }
}

