/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.googlecode;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.googlecode.GoogleCodeLinkAnnotator;
import hudson.plugins.googlecode.GoogleCodeProjectProperty;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleCodeLinkAnnotator
extends ChangeLogAnnotator {
    private GoogleCodeProjectProperty.PropertyRetriever propertyRetriever;
    static final LinkMarkup[] MARKUPS = new LinkMarkup[]{new LinkMarkup("issue #?NUM", "issues/detail?id=$1"), new LinkMarkup("issue #?NUM:NUM", "issues/detail?id=$1#$2"), new LinkMarkup("((?:[A-Z][a-z]+){2,})|wiki:ANYWORD", "wiki/$1$2")};

    public GoogleCodeLinkAnnotator(GoogleCodeProjectProperty.PropertyRetriever propertyRetriever) {
        this.propertyRetriever = propertyRetriever;
    }

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        GoogleCodeProjectProperty property = this.propertyRetriever.getProperty(build);
        if (property == null || property.googlecodeWebsite == null) {
            return;
        }
        String url = property.googlecodeWebsite;
        for (LinkMarkup markup : MARKUPS) {
            markup.process(text, url);
        }
    }
}

