/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.googlecode;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.googlecode.GoogleCodeProjectProperty;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleCodeLinkAnnotator
extends ChangeLogAnnotator {
    private GoogleCodeProjectProperty.PropertyRetriever propertyRetriever;
    static final LinkMarkup[] MARKUPS = new LinkMarkup[]{new LinkMarkup("issue #?NUM", "issues/detail?id=$1"), new LinkMarkup("issue #?NUM:NUM", "issues/detail?id=$1#$2"), new LinkMarkup("((?:[A-Z][a-z]+){2,})|wiki:ANYWORD", "wiki/$1$2")};

    public GoogleCodeLinkAnnotator(GoogleCodeProjectProperty.PropertyRetriever propertyRetriever) {
        this.propertyRetriever = propertyRetriever;
    }

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        GoogleCodeProjectProperty property = this.propertyRetriever.getProperty(build);
        if (property == null || property.googlecodeWebsite == null) {
            return;
        }
        String url = property.googlecodeWebsite;
        for (LinkMarkup markup : MARKUPS) {
            markup.process(text, url);
        }
    }

    static final class LinkMarkup {
        private final Pattern pattern;
        private final String href;
        private static final Pattern NUM_PATTERN = Pattern.compile("NUM");
        private static final Pattern ANYWORD_PATTERN = Pattern.compile("ANYWORD");

        LinkMarkup(String pattern, String href) {
            pattern = NUM_PATTERN.matcher(pattern).replaceAll("(\\\\d+)");
            pattern = ANYWORD_PATTERN.matcher(pattern).replaceAll("((?:\\\\w|[._-])+)");
            this.pattern = Pattern.compile(pattern);
            this.href = href;
        }

        void process(MarkupText text, String url) {
            for (MarkupText.SubText st : text.findTokens(this.pattern)) {
                st.surroundWith("<a href='" + url + this.href + "'>", "</a>");
            }
        }
    }
}

