/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.googlecode.scm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.plugins.googlecode.GoogleCodeProjectProperty;
import hudson.plugins.googlecode.GoogleCodeRepositoryBrowser;
import hudson.plugins.googlecode.PluginImpl;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.SubversionSCM;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleCodeSCM
extends SCM {
    private transient SCM configuredScm;
    private String directory;

    @DataBoundConstructor
    public GoogleCodeSCM(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        if (Util.fixEmptyAndTrim((String)this.directory) == null) {
            this.directory = "trunk";
        }
        return this.directory;
    }

    private SCM getSCM() {
        if (this.configuredScm == null) {
            List projects = Hudson.getInstance().getProjects();
            for (Project project : projects) {
                if (this != project.getScm()) continue;
                GoogleCodeProjectProperty property = (GoogleCodeProjectProperty)project.getProperty(GoogleCodeProjectProperty.class);
                if (property != null) {
                    String path = this.directory;
                    String[] remoteLocations = new String[]{"http://" + property.getProjectName() + ".googlecode.com/svn/" + path};
                    String[] localLocations = new String[]{"."};
                    this.configuredScm = new SubversionSCM(remoteLocations, localLocations, true, (SubversionRepositoryBrowser)new GoogleCodeRepositoryBrowser((GoogleCodeProjectProperty.PropertyRetriever)PluginImpl.PROJECT_PROPERTY_DESCRIPTOR));
                    break;
                }
                throw new RuntimeException("The project does not have a google code property. Please report this to the plugin author.");
            }
            if (this.configuredScm == null) {
                throw new RuntimeException("Could not find the project for this SCM object. Please contact plugin author.");
            }
        }
        return this.configuredScm;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        this.getSCM().buildEnvVars(build, env);
    }

    public RepositoryBrowser getBrowser() {
        return this.getSCM().getBrowser();
    }

    public FilePath getModuleRoot(FilePath workspace) {
        return this.getSCM().getModuleRoot(workspace);
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        return this.getSCM().getModuleRoots(workspace);
    }

    public boolean requiresWorkspaceForPolling() {
        return this.getSCM().requiresWorkspaceForPolling();
    }

    public boolean supportsPolling() {
        return this.getSCM().supportsPolling();
    }

    public boolean checkout(AbstractBuild arg0, Launcher arg1, FilePath arg2, BuildListener arg3, File arg4) throws IOException, InterruptedException {
        return this.getSCM().checkout(arg0, arg1, arg2, arg3, arg4);
    }

    public boolean pollChanges(AbstractProject arg0, Launcher arg1, FilePath arg2, TaskListener arg3) throws IOException, InterruptedException {
        return this.getSCM().pollChanges(arg0, arg1, arg2, arg3);
    }

    public ChangeLogParser createChangeLogParser() {
        return this.getSCM().createChangeLogParser();
    }

    public SCMDescriptor<?> getDescriptor() {
        return PluginImpl.GOOGLE_CODE_SCM_DESCRIPTOR;
    }
}

