/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.googlecode;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.googlecode.PluginImpl;
import hudson.scm.SubversionChangeLogSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoogleCodeProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public final String googlecodeWebsite;
    private transient String projectName;

    @DataBoundConstructor
    public GoogleCodeProjectProperty(String googlecodeWebsite) {
        if (googlecodeWebsite == null || googlecodeWebsite.length() == 0) {
            googlecodeWebsite = null;
        } else if (!googlecodeWebsite.endsWith("/")) {
            googlecodeWebsite = googlecodeWebsite + '/';
        }
        this.googlecodeWebsite = googlecodeWebsite;
    }

    public String getProjectName() {
        if (this.projectName == null) {
            Matcher matcher = Pattern.compile(".*\\/p\\/([\\w-]*)").matcher(this.googlecodeWebsite);
            matcher.find();
            this.projectName = matcher.group(1);
        }
        return this.projectName;
    }

    public DescriptorImpl getDescriptor() {
        return PluginImpl.PROJECT_PROPERTY_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertyRetriever {
        public GoogleCodeProjectProperty getProperty(AbstractBuild<?, ?> var1);

        public GoogleCodeProjectProperty getProperty(SubversionChangeLogSet.LogEntry var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor
    implements PropertyRetriever {
        public DescriptorImpl() {
            super(GoogleCodeProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Associated Google Code website";
        }

        public GoogleCodeProjectProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (GoogleCodeProjectProperty)((Object)req.bindJSON(GoogleCodeProjectProperty.class, formData));
        }

        @Override
        public GoogleCodeProjectProperty getProperty(AbstractBuild<?, ?> build) {
            return (GoogleCodeProjectProperty)build.getProject().getProperty(GoogleCodeProjectProperty.class);
        }

        @Override
        public GoogleCodeProjectProperty getProperty(SubversionChangeLogSet.LogEntry entry) {
            return this.getProperty(entry.getParent().build);
        }
    }
}

