/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.googlecode;

import hudson.model.AbstractProject;
import hudson.model.JobProperty;
import hudson.plugins.googlecode.GoogleCodeProjectProperty;
import hudson.plugins.googlecode.PluginImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoogleCodeProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public final String googlecodeWebsite;
    private transient String projectName;

    @DataBoundConstructor
    public GoogleCodeProjectProperty(String googlecodeWebsite) {
        if (googlecodeWebsite == null || googlecodeWebsite.length() == 0) {
            googlecodeWebsite = null;
        } else if (!googlecodeWebsite.endsWith("/")) {
            googlecodeWebsite = googlecodeWebsite + '/';
        }
        this.googlecodeWebsite = googlecodeWebsite;
    }

    public String getProjectName() {
        if (this.projectName == null) {
            Matcher matcher = Pattern.compile(".*\\/p\\/([\\w-]*)").matcher(this.googlecodeWebsite);
            matcher.find();
            this.projectName = matcher.group(1);
        }
        return this.projectName;
    }

    public DescriptorImpl getDescriptor() {
        return PluginImpl.PROJECT_PROPERTY_DESCRIPTOR;
    }
}

