/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.googlecode;

import hudson.plugins.googlecode.GoogleCodeProjectProperty;
import hudson.plugins.googlecode.GoogleCodeRepositoryBrowser;
import hudson.plugins.googlecode.PluginImpl;
import hudson.scm.EditType;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

public class GoogleCodeRepositoryBrowser
extends SubversionRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private transient GoogleCodeProjectProperty.PropertyRetriever propertyRetriever;

    @DataBoundConstructor
    public GoogleCodeRepositoryBrowser(GoogleCodeProjectProperty.PropertyRetriever retriever) {
        this.propertyRetriever = retriever;
    }

    private URL getGoogleCodeWebURL(SubversionChangeLogSet.LogEntry cs) throws MalformedURLException {
        GoogleCodeProjectProperty property;
        if (this.propertyRetriever == null) {
            this.propertyRetriever = PluginImpl.PROJECT_PROPERTY_DESCRIPTOR;
        }
        if ((property = this.propertyRetriever.getProperty(cs)) == null || property.googlecodeWebsite == null) {
            return null;
        }
        return new URL(property.googlecodeWebsite);
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        URL baseUrl = this.getGoogleCodeWebURL(path.getLogEntry());
        int revision = path.getLogEntry().getRevision();
        return new URL(baseUrl, "source/diff?r=" + revision + "&format=side&path=" + path.getValue());
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        URL baseUrl = this.getGoogleCodeWebURL(path.getLogEntry());
        int revision = path.getLogEntry().getRevision();
        return baseUrl == null ? null : new URL(baseUrl, "source/browse" + path.getValue() + "?r=" + revision + "#1");
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        URL baseUrl = this.getGoogleCodeWebURL(changeSet);
        return baseUrl == null ? null : new URL(baseUrl, "source/detail?r=" + changeSet.getRevision());
    }

    public DescriptorImpl getDescriptor() {
        return PluginImpl.REPOSITORY_BROWSER_DESCRIPTOR;
    }
}

