/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.googlecode.scm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.googlecode.GoogleCodeProjectProperty;
import hudson.plugins.googlecode.GoogleCodeRepositoryBrowser;
import hudson.plugins.googlecode.PluginImpl;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.SubversionSCM;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleCodeSCM
extends SCM {
    private transient SCM configuredScm;
    private String directory;

    @DataBoundConstructor
    public GoogleCodeSCM(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        if (Util.fixEmptyAndTrim((String)this.directory) == null) {
            this.directory = "trunk";
        }
        return this.directory;
    }

    private SCM getSCM() {
        if (this.configuredScm == null) {
            for (AbstractProject project : Hudson.getInstance().getItems(AbstractProject.class)) {
                if (this != project.getScm()) continue;
                GoogleCodeProjectProperty property = (GoogleCodeProjectProperty)project.getProperty(GoogleCodeProjectProperty.class);
                if (property != null) {
                    String path = this.directory;
                    String[] remoteLocations = new String[]{"http://" + property.getProjectName() + ".googlecode.com/svn/" + path};
                    String[] localLocations = new String[]{"."};
                    this.configuredScm = new SubversionSCM(remoteLocations, localLocations, true, (SubversionRepositoryBrowser)new GoogleCodeRepositoryBrowser(PluginImpl.PROJECT_PROPERTY_DESCRIPTOR));
                    break;
                }
                throw new RuntimeException("The project does not have a google code property. Please report this to the plugin author.");
            }
            if (this.configuredScm == null) {
                throw new RuntimeException("Could not find the project for this SCM object. Please contact plugin author.");
            }
        }
        return this.configuredScm;
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        this.getSCM().buildEnvVars(build, env);
    }

    public RepositoryBrowser getBrowser() {
        return this.getSCM().getBrowser();
    }

    public FilePath getModuleRoot(FilePath workspace) {
        return this.getSCM().getModuleRoot(workspace);
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        return this.getSCM().getModuleRoots(workspace);
    }

    public boolean requiresWorkspaceForPolling() {
        return this.getSCM().requiresWorkspaceForPolling();
    }

    public boolean supportsPolling() {
        return this.getSCM().supportsPolling();
    }

    public boolean checkout(AbstractBuild arg0, Launcher arg1, FilePath arg2, BuildListener arg3, File arg4) throws IOException, InterruptedException {
        return this.getSCM().checkout(arg0, arg1, arg2, arg3, arg4);
    }

    public boolean pollChanges(AbstractProject arg0, Launcher arg1, FilePath arg2, TaskListener arg3) throws IOException, InterruptedException {
        return this.getSCM().pollChanges(arg0, arg1, arg2, arg3);
    }

    public ChangeLogParser createChangeLogParser() {
        return this.getSCM().createChangeLogParser();
    }

    public SCMDescriptor<?> getDescriptor() {
        return PluginImpl.GOOGLE_CODE_SCM_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends SCMDescriptor<GoogleCodeSCM> {
        public DescriptorImpl() {
            super(GoogleCodeSCM.class, GoogleCodeRepositoryBrowser.class);
        }

        public GoogleCodeSCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (GoogleCodeSCM)((Object)req.bindJSON(GoogleCodeSCM.class, formData));
        }

        public String getDisplayName() {
            return "Google Code (automatic configuration)";
        }
    }
}

