/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.googlecode.scm;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.googlecode.GoogleCodeProjectProperty;
import hudson.plugins.googlecode.GoogleCodeRepositoryBrowser;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.SubversionSCM;
import java.util.Arrays;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GoogleCodeSCMEx
extends SubversionSCM {
    private static final long serialVersionUID = 1L;
    private String directory;

    @DataBoundConstructor
    public GoogleCodeSCMEx(String directory, SubversionSCM.ModuleLocation locations) {
        super(Arrays.asList(locations), true, (SubversionRepositoryBrowser)new GoogleCodeRepositoryBrowser(new GoogleCodeProjectProperty.PropertyRetrieverImpl()), "");
        this.directory = directory;
    }

    public String getDirectory() {
        if (Util.fixEmptyAndTrim((String)this.directory) == null) {
            this.directory = "trunk";
        }
        return this.directory;
    }

    public static class DescriptorImpl
    extends SubversionSCM.DescriptorImpl {
        public DescriptorImpl() {
            super(GoogleCodeSCMEx.class, GoogleCodeRepositoryBrowser.class);
        }

        public GoogleCodeSCMEx newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String projectWebsite = req.getParameter("googlecode.googlecodeWebsite");
            String directory = req.getParameter("googlecode.svnRemoteDirectory");
            if (Util.fixEmptyAndTrim((String)projectWebsite) == null) {
                throw new IllegalArgumentException("The Google Code project site field can not be empty when selecting the Google Code SCM.");
            }
            if (Util.fixEmptyAndTrim((String)directory) == null) {
                directory = "trunk";
            }
            return DescriptorImpl.newInstance(new GoogleCodeProjectProperty(projectWebsite), directory);
        }

        public static GoogleCodeSCMEx newInstance(GoogleCodeProjectProperty property, String remoteDirectory) {
            return new GoogleCodeSCMEx(remoteDirectory, new SubversionSCM.ModuleLocation(property.getSubversionRootUrl() + remoteDirectory, "."));
        }

        public String getDisplayName() {
            return "Google Code (automatic configuration)";
        }
    }
}

