/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.googlecode.scm;

import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import hudson.plugins.googlecode.GoogleCodeProjectProperty;
import hudson.plugins.googlecode.scm.GoogleCodeSCM;
import hudson.plugins.googlecode.scm.GoogleCodeSCMEx;
import hudson.scm.SCM;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleCodeSCMUpgrader
extends ItemListener {
    private static final Logger logger = Logger.getLogger(GoogleCodeSCMUpgrader.class.getName());

    public void onLoaded() {
        this.onLoaded(Hudson.getInstance().getItems());
    }

    void onLoaded(List<TopLevelItem> items) {
        for (TopLevelItem item : items) {
            AbstractProject abstractProject;
            SCM oldScm;
            if (!(item instanceof AbstractProject) || !((oldScm = (abstractProject = (AbstractProject)item).getScm()) instanceof GoogleCodeSCM)) continue;
            this.upgradeScmInProject(abstractProject, (GoogleCodeSCM)oldScm);
        }
    }

    void upgradeScmInProject(AbstractProject<?, ?> abstractProject, GoogleCodeSCM oldScm) {
        String name = abstractProject.getName();
        try {
            GoogleCodeSCMEx scmCopy = this.copy(oldScm, (GoogleCodeProjectProperty)abstractProject.getProperty(GoogleCodeProjectProperty.class));
            abstractProject.setScm((SCM)scmCopy);
            abstractProject.save();
            logger.info("Upgraded Google Code SCM in '" + name + "'.");
        }
        catch (Exception e) {
            logger.warning("Error while upgrading Google Code SCM configuration for '" + name + "'. The project is still usable, but should be manually configured again. " + "For more information please see https://hudson.dev.java.net/issues/show_bug.cgi?id=4136.");
            abstractProject.setScm((SCM)oldScm);
        }
    }

    GoogleCodeSCMEx copy(GoogleCodeSCM source, GoogleCodeProjectProperty property) {
        return GoogleCodeSCMEx.DescriptorImpl.newInstance(property, source.getDirectory());
    }
}

