/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.plugins.gradle.Gradle;
import hudson.plugins.gradle.GradleInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gradle
extends Builder {
    private final String targets;
    private final String gradleName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl(null);

    @DataBoundConstructor
    public Gradle(String targets, String gradleName) {
        this.targets = targets;
        this.gradleName = gradleName;
    }

    public String getTargets() {
        return this.targets;
    }

    public GradleInstallation getGradle() {
        for (GradleInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.gradleName == null || !i.getName().equals(this.gradleName)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Project proj = (Project)build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = launcher.isUnix() ? "gradle" : "gradle.exe";
        String normalizedTarget = this.targets.replaceAll("[\t\r\n]+", " ");
        GradleInstallation ai = this.getGradle();
        if (ai == null) {
            args.add(execName);
        } else {
            File exec = ai.getExecutable();
            if (!ai.getExists()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(normalizedTarget);
        Map env = build.getEnvVars();
        if (ai != null) {
            env.put("GRADLE_HOME", ai.getGradleHome());
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch(args.toCommandArray(), env, (OutputStream)listener.getLogger(), proj.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }
}

