/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.plugins.gradle.GradleInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gradle
extends Builder {
    private final String targets;
    private final String gradleName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public Gradle(String targets, String gradleName) {
        this.targets = targets;
        this.gradleName = gradleName;
    }

    public String getTargets() {
        return this.targets;
    }

    public GradleInstallation getGradle() {
        for (GradleInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.gradleName == null || !i.getName().equals(this.gradleName)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Project proj = (Project)build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = launcher.isUnix() ? "gradle" : "gradle.exe";
        String normalizedTarget = this.targets.replaceAll("[\t\r\n]+", " ");
        GradleInstallation ai = this.getGradle();
        if (ai == null) {
            args.add(execName);
        } else {
            File exec = ai.getExecutable();
            if (!ai.getExists()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(normalizedTarget);
        Map env = build.getEnvVars();
        if (ai != null) {
            env.put("GRADLE_HOME", ai.getGradleHome());
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch(args.toCommandArray(), env, (OutputStream)listener.getLogger(), proj.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        private volatile GradleInstallation[] installations = new GradleInstallation[0];

        private DescriptorImpl() {
            super(Gradle.class);
            this.load();
        }

        public String getHelpFile() {
            return "/plugin/gradle/help.html";
        }

        public String getDisplayName() {
            return "Invoke Gradle script";
        }

        public GradleInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req) {
            this.installations = req.bindParametersToList(GradleInstallation.class, "gradle.").toArray(new GradleInstallation[0]);
            this.save();
            return true;
        }

        public void doCheckGradleHome(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                public void check() throws IOException, ServletException {
                    File f = this.getFileParameter("value");
                    if (!f.isDirectory()) {
                        this.error(f + " is not a directory");
                        return;
                    }
                    if (!new File(f, "bin/gradle").exists() && !new File(f, "bin/gradle.exe").exists()) {
                        this.error(f + " doesn't look like a Gradle directory");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }
    }
}

