/*
 * Decompiled with CFR 0.152.
 */
package com.g2one.hudson.grails;

import com.g2one.hudson.grails.GrailsBuilder;
import com.g2one.hudson.grails.GrailsInstallation;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.UnflaggedOption;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GrailsBuilder
extends Builder {
    private final String targets;
    private final String name;
    private String grailsWorkDir;
    private String projectWorkDir;
    private String projectBaseDir;
    private String serverPort;
    private String properties;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public GrailsBuilder(String targets, String name, String grailsWorkDir, String projectWorkDir, String projectBaseDir, String serverPort, String properties) {
        this.name = name;
        this.targets = targets;
        this.grailsWorkDir = grailsWorkDir;
        this.projectWorkDir = projectWorkDir;
        this.projectBaseDir = projectBaseDir;
        this.serverPort = serverPort;
        this.properties = properties;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String getProjectBaseDir() {
        return this.projectBaseDir;
    }

    public void setProjectBaseDir(String projectBaseDir) {
        this.projectBaseDir = projectBaseDir;
    }

    public String getProjectWorkDir() {
        return this.projectWorkDir;
    }

    public void setProjectWorkDir(String projectWorkDir) {
        this.projectWorkDir = projectWorkDir;
    }

    public String getGrailsWorkDir() {
        return this.grailsWorkDir;
    }

    public void setGrailsWorkDir(String grailsWorkDir) {
        this.grailsWorkDir = grailsWorkDir;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getName() {
        return this.name;
    }

    public String getTargets() {
        return this.targets;
    }

    public GrailsInstallation getGrails() {
        for (GrailsInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.name == null || !i.getName().equals(this.name)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        List targetsToRun = this.getTargetsToRun();
        if (targetsToRun.size() > 0) {
            String execName = launcher.isUnix() ? "grails" : "grails.bat";
            GrailsInstallation grailsInstallation = this.getGrails();
            EnvVars env = build.getEnvironment((TaskListener)listener);
            if (grailsInstallation != null) {
                env.put("GRAILS_HOME", grailsInstallation.getGrailsHome());
            }
            for (String[] targetsAndArgs : targetsToRun) {
                String target = targetsAndArgs[0];
                ArgumentListBuilder args = new ArgumentListBuilder();
                if (grailsInstallation == null) {
                    args.add(execName);
                } else {
                    File exec = grailsInstallation.getExecutable();
                    if (!grailsInstallation.getExists()) {
                        listener.fatalError(exec + " doesn't exist");
                        return false;
                    }
                    args.add(exec.getPath());
                }
                args.addKeyValuePairs("-D", build.getBuildVariables());
                HashMap<String, String> sytemProperties = new HashMap<String, String>();
                if (this.grailsWorkDir != null && !"".equals(this.grailsWorkDir.trim())) {
                    sytemProperties.put("grails.work.dir", this.grailsWorkDir.trim());
                }
                if (this.projectWorkDir != null && !"".equals(this.projectWorkDir.trim())) {
                    sytemProperties.put("project.work.dir", this.projectWorkDir.trim());
                }
                if (this.serverPort != null && !"".equals(this.serverPort.trim())) {
                    sytemProperties.put("server.port", this.serverPort.trim());
                }
                if (sytemProperties.size() > 0) {
                    args.addKeyValuePairs("-D", sytemProperties);
                }
                args.addKeyValuePairsFromPropertyString("-D", this.properties, build.getBuildVariableResolver());
                args.add(target);
                for (int i = 1; i < targetsAndArgs.length; ++i) {
                    args.add(GrailsBuilder.evalTarget((Map)env, (String)targetsAndArgs[i]));
                }
                if (!launcher.isUnix()) {
                    args.prepend(new String[]{"cmd.exe", "/C"});
                    args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
                }
                try {
                    FilePath moduleRoot = build.getModuleRoot();
                    FilePath basePath = this.projectBaseDir != null && !"".equals(this.projectBaseDir.trim()) ? new FilePath(moduleRoot, this.projectBaseDir) : moduleRoot;
                    int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(basePath).join();
                    if (r == 0) continue;
                    return false;
                }
                catch (IOException e) {
                    Util.displayIOException((IOException)e, (TaskListener)listener);
                    e.printStackTrace(listener.fatalError("command execution failed"));
                    return false;
                }
            }
        } else {
            listener.getLogger().println("Error: No Targets To Run!");
            return false;
        }
        return true;
    }

    static String evalTarget(Map<String, String> env, String target) {
        Binding binding = new Binding();
        binding.setVariable("env", env);
        binding.setVariable("sys", (Object)System.getProperties());
        GroovyShell shell = new GroovyShell(binding);
        Object result = shell.evaluate("return \"" + target + "\"");
        if (result == null) {
            return target;
        }
        return result.toString().trim();
    }

    protected List<String[]> getTargetsToRun() {
        ArrayList<String[]> targetsToRun = new ArrayList<String[]>();
        if (this.targets != null && this.targets.length() > 0) {
            try {
                String[] targets;
                JSAP jsap = new JSAP();
                UnflaggedOption option = new UnflaggedOption("targets");
                option.setGreedy(true);
                jsap.registerParameter((Parameter)option);
                JSAPResult jsapResult = jsap.parse(this.targets);
                for (String targetAndArgs : targets = jsapResult.getStringArray("targets")) {
                    String[] pieces = targetAndArgs.split(" ");
                    targetsToRun.add(pieces);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return targetsToRun;
    }
}

