/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.grinder;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.grinder.AbstractGrinderAction;
import hudson.plugins.grinder.ResultReader;
import hudson.plugins.grinder.Test;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrinderBuildAction
extends AbstractGrinderAction {
    private final AbstractBuild<?, ?> build;
    private Test totals;
    private List<Test> tests;

    public GrinderBuildAction(AbstractBuild<?, ?> build, InputStream is, PrintStream logger) {
        this.build = build;
        ResultReader rs = new ResultReader(is, logger);
        this.totals = rs.getTotals();
        this.tests = rs.getTests();
        logger.println("Created Grinder results");
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public Test getTotals() {
        return this.totals;
    }

    public List<Test> getTests() {
        return this.tests;
    }

    public void doTestGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.shouldReloadGraph(request, response, (Run)this.build)) {
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createTestGraph(), (int)800, (int)400);
        }
    }

    private JFreeChart createTestGraph() {
        DefaultStatisticalCategoryDataset timeDS = new DefaultStatisticalCategoryDataset();
        DataSetBuilder lengthDS = new DataSetBuilder();
        for (Test test : this.tests) {
            timeDS.add(test.getMeanTime(), test.getStdDev(), (Comparable)((Object)"Mean Test Time"), (Comparable)((Object)test.getId()));
            lengthDS.add(test.getMeanRespLength(), (Comparable)((Object)"Mean Response Length"), (Comparable)((Object)test.getId()));
        }
        CategoryAxis xAxis = new CategoryAxis("Test name");
        xAxis.setLowerMargin(0.01);
        xAxis.setUpperMargin(0.01);
        xAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        xAxis.setMaximumCategoryLabelLines(3);
        NumberAxis timeAxis = new NumberAxis("Time (ms)");
        NumberAxis lengthAxis = new NumberAxis("Length (bytes)");
        StatisticalBarRenderer timeRenderer = new StatisticalBarRenderer();
        timeRenderer.setSeriesPaint(2, (Paint)ColorPalette.RED);
        timeRenderer.setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
        timeRenderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        timeRenderer.setItemMargin(0.0);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)timeDS, xAxis, (ValueAxis)timeAxis, (CategoryItemRenderer)timeRenderer);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        LineAndShapeRenderer lengthRenderer = new LineAndShapeRenderer();
        plot.setRangeAxis(1, (ValueAxis)lengthAxis);
        plot.setDataset(1, lengthDS.build());
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setRenderer(1, (CategoryItemRenderer)lengthRenderer);
        JFreeChart chart = new JFreeChart("Test time", (Plot)plot);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        return chart;
    }
}

