/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.grinder;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.grinder.GrinderBuildAction;
import hudson.plugins.grinder.GrinderParseException;
import hudson.plugins.grinder.GrinderProjectAction;
import hudson.plugins.grinder.GrinderPublisher;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrinderPublisher
extends Publisher {
    private String name;
    public static final Descriptor<Publisher> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public GrinderPublisher(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (build.getProject().getWorkspace().child(this.name).exists()) {
            InputStream is = build.getProject().getWorkspace().child(this.name).read();
            try {
                build.addAction((Action)new GrinderBuildAction(build, is, logger));
            }
            catch (GrinderParseException gpe) {
                logger.println("Grinder report failed!");
                build.setResult(Result.FAILURE);
            }
        } else {
            logger.println("Grinder out* log file not found!");
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    public Action getProjectAction(Project project) {
        return new GrinderProjectAction(project);
    }
}

