/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.grinder;

import hudson.plugins.grinder.GrinderParseException;
import hudson.plugins.grinder.Test;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultReader {
    private List<Test> tests;
    private Test totals;
    private final transient PrintStream hudsonConsoleWriter;
    private static final String PATTERN_TEST = "Test \\d.*";
    private static final String PATTERN_TOTALS = "Totals .*";
    private static final String PATTERN_TPS = " TPS ";

    public ResultReader(InputStream is, PrintStream logger) {
        this.hudsonConsoleWriter = logger;
        this.parse(is);
    }

    private void parse(InputStream is) {
        if (is == null) {
            throw new GrinderParseException("Empty input stream");
        }
        if (this.tests == null) {
            this.tests = new ArrayList();
        }
        try {
            String str = IOUtils.toString((InputStream)is);
            boolean hasTPS = str.contains(PATTERN_TPS);
            Scanner scanner = new Scanner(str);
            String match = scanner.findWithinHorizon(PATTERN_TEST, 0);
            while (match != null) {
                this.tests.add(this.readTest(match, false, hasTPS));
                match = scanner.findWithinHorizon(PATTERN_TEST, 0);
            }
            match = scanner.findWithinHorizon(PATTERN_TOTALS, 0);
            this.totals = this.readTest(match, true, hasTPS);
        }
        catch (IOException e) {
            String errMsg = "Problem parsing Grinder out log file";
            this.hudsonConsoleWriter.println(errMsg + ": " + e.getMessage());
            e.printStackTrace(this.hudsonConsoleWriter);
            throw new GrinderParseException(errMsg, (Exception)e);
        }
    }

    public List<Test> getTests() {
        return this.tests;
    }

    public Test getTotals() {
        return this.totals;
    }

    private Test readTest(String testLine, boolean isTotals, boolean hasTPS) {
        Scanner scanner = new Scanner(testLine).useDelimiter("\\s{2,}").useLocale(Locale.ENGLISH);
        String id = scanner.next();
        int testCount = scanner.nextInt();
        int errorCount = scanner.nextInt();
        double meanTestTime = scanner.nextDouble();
        double testStdDevTime = scanner.nextDouble();
        if (scanner.hasNextDouble()) {
            double tps = 0.0;
            if (hasTPS) {
                tps = scanner.nextDouble();
            }
            double meanRespLength = scanner.nextDouble();
            double respBytesPrSecond = 0.0;
            if (scanner.hasNextDouble()) {
                respBytesPrSecond = scanner.nextDouble();
            } else {
                scanner.next();
            }
            int respErrorCount = scanner.nextInt();
            double resolveHostMeanTime = scanner.nextDouble();
            double establishConnMeanTime = scanner.nextDouble();
            double firstByteMeanTime = scanner.nextDouble();
            String name = isTotals ? "" : scanner.next().replaceAll("\"", "");
            return new Test(id, testCount, errorCount, meanTestTime, testStdDevTime, tps, meanRespLength, respBytesPrSecond, respErrorCount, resolveHostMeanTime, establishConnMeanTime, firstByteMeanTime, name);
        }
        String name = isTotals ? "" : scanner.next().replaceAll("\"", "");
        return new Test(id, testCount, errorCount, meanTestTime, testStdDevTime, name);
    }
}

