/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.grinder;

import java.util.HashMap;
import java.util.Map;

public class Test {
    public static final String MEAN_RESPONSE_LENGTH = "Mean Response Length";
    public static final String TEST_COUNT = "Test Count";
    public static final String ERROR_COUNT = "Error Count";
    public static final String MEAN_TEST_TIME = "Mean Test Time";
    public static final String TEST_TIME_STANDARD_DEVIATION = "Test Time Standard Deviation";
    public static final String TPS = "TPS";
    public static final String RESPONSE_BYTES_PER_SECOND = "Response Bytes Per Second";
    public static final String RESPONSE_ERROR_COUNT = "Response Error Count";
    public static final String RESOLVE_HOST_MEAN_TIME = "Resolve Host Mean Time";
    public static final String ESTABLISH_CONNECTION_MEAN_TIME = "Establish Connection Mean Time";
    public static final String FIRST_BYTE_MEAN_TIME = "First Byte Mean Time";
    private String id;
    private String name;
    private Map<String, Number> values = new HashMap<String, Number>();

    public Test(String id, int testCount, int errorCount, double meanTime, double stdDev, double tps, double meanRespLength, double respBytesPrSecond, int respErrorCount, double resolveHostMeanTime, double establishConnMeanTime, double firstByteMeanTime, String name) {
        this(id, testCount, errorCount, meanTime, stdDev, name);
        this.values.put(TPS, tps);
        this.values.put(MEAN_RESPONSE_LENGTH, meanRespLength);
        this.values.put(RESPONSE_BYTES_PER_SECOND, respBytesPrSecond);
        this.values.put(RESPONSE_ERROR_COUNT, respErrorCount);
        this.values.put(RESOLVE_HOST_MEAN_TIME, resolveHostMeanTime);
        this.values.put(ESTABLISH_CONNECTION_MEAN_TIME, establishConnMeanTime);
        this.values.put(FIRST_BYTE_MEAN_TIME, firstByteMeanTime);
    }

    public Test(String id, int testCount, int errorCount, double meanTime, double stdDev, String name) {
        this.id = id;
        this.values.put(TEST_COUNT, testCount);
        this.values.put(ERROR_COUNT, errorCount);
        this.values.put(MEAN_TEST_TIME, meanTime);
        this.values.put(TEST_TIME_STANDARD_DEVIATION, stdDev);
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public Number getTestCount() {
        return this.values.get(TEST_COUNT);
    }

    public Number getErrorCount() {
        return this.values.get(ERROR_COUNT);
    }

    public Number getMeanTime() {
        return this.values.get(MEAN_TEST_TIME);
    }

    public Number getStdDev() {
        return this.values.get(TEST_TIME_STANDARD_DEVIATION);
    }

    public Number getTPS() {
        return this.values.get(TPS);
    }

    public Number getMeanRespLength() {
        return this.values.get(MEAN_RESPONSE_LENGTH);
    }

    public Number getRespBytesPrSecond() {
        return this.values.get(RESPONSE_BYTES_PER_SECOND);
    }

    public Number getRespErrorCount() {
        return this.values.get(RESPONSE_ERROR_COUNT);
    }

    public Number getResolveHostMeanTime() {
        return this.values.get(RESOLVE_HOST_MEAN_TIME);
    }

    public Number getEstablishConnMeanTime() {
        return this.values.get(ESTABLISH_CONNECTION_MEAN_TIME);
    }

    public Number getFirstByteMeanTime() {
        return this.values.get(FIRST_BYTE_MEAN_TIME);
    }

    public Number getValue(String name) {
        return this.values.get(name);
    }

    public String getName() {
        return this.name;
    }
}

