/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.groovypostbuild;

import groovy.lang.GroovyShell;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.groovypostbuild.GroovyPostbuildRecorder;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPostbuildRecorder
extends Recorder {
    private static final Logger LOGGER = Logger.getLogger(GroovyPostbuildRecorder.class.getName());
    private final String groovyScript;

    @DataBoundConstructor
    public GroovyPostbuildRecorder(String groovyScript) {
        this.groovyScript = groovyScript;
        LOGGER.fine("GroovyPostbuildRecorder created with groovyScript:\n" + groovyScript);
    }

    public final Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        LOGGER.fine("perform() called for script:\n" + this.groovyScript);
        BadgeManager badgeManager = new BadgeManager(build, listener);
        GroovyShell shell = new GroovyShell();
        shell.setVariable("manager", (Object)badgeManager);
        try {
            shell.evaluate(this.groovyScript);
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Failed to evaluate groovy script."));
        }
        build.save();
        return build.getResult().isBetterThan(Result.FAILURE);
    }

    public final BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getGroovyScript() {
        return this.groovyScript;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

