/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.groovypostbuild;

import hudson.PluginWrapper;
import hudson.model.BuildBadgeAction;
import hudson.model.Hudson;
import java.io.File;
import org.jvnet.hudson.plugins.groovypostbuild.GroovyPostbuildPlugin;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public class GroovyPostbuildAction
implements BuildBadgeAction {
    private final String iconPath;
    private final String text;
    private String color = "#000000";
    private String background = "#FFFF00";
    private String border = "1px";
    private String borderColor = "#C0C000";

    private GroovyPostbuildAction(String iconPath, String text) {
        this.iconPath = iconPath;
        this.text = text;
    }

    public static GroovyPostbuildAction createBadge(String icon, String text) {
        return new GroovyPostbuildAction(GroovyPostbuildAction.getIconPath(icon), text);
    }

    public static GroovyPostbuildAction createShortText(String text) {
        return new GroovyPostbuildAction(null, text);
    }

    public static GroovyPostbuildAction createShortText(String text, String color, String background, String border, String borderColor) {
        GroovyPostbuildAction action = new GroovyPostbuildAction(null, text);
        action.color = color;
        action.background = background;
        action.border = border;
        action.borderColor = borderColor;
        return action;
    }

    public static GroovyPostbuildAction createInfoBadge(String text) {
        return new GroovyPostbuildAction(GroovyPostbuildAction.getIconPath("info.gif"), text);
    }

    public static GroovyPostbuildAction createWarningBadge(String text) {
        return new GroovyPostbuildAction(GroovyPostbuildAction.getIconPath("warning.gif"), text);
    }

    public static GroovyPostbuildAction createErrorBadge(String text) {
        return new GroovyPostbuildAction(GroovyPostbuildAction.getIconPath("error.gif"), text);
    }

    public String getUrlName() {
        return "";
    }

    public String getDisplayName() {
        return "";
    }

    public String getIconFileName() {
        return null;
    }

    @Exported
    public boolean isTextOnly() {
        return this.iconPath == null;
    }

    @Exported
    public String getIconPath() {
        return this.iconPath;
    }

    @Exported
    public String getText() {
        return this.text;
    }

    @Exported
    public String getColor() {
        return this.color;
    }

    @Exported
    public String getBackground() {
        return this.background;
    }

    @Exported
    public String getBorder() {
        return this.border;
    }

    @Exported
    public String getBorderColor() {
        return this.borderColor;
    }

    public static String getIconPath(String icon) {
        if (icon == null) {
            return null;
        }
        if (icon.startsWith("/")) {
            return icon;
        }
        PluginWrapper wrapper = Hudson.getInstance().getPluginManager().getPlugin(GroovyPostbuildPlugin.class);
        return new File(wrapper.baseResourceURL.getPath() + "/images/" + icon).exists() ? "/plugin/" + wrapper.getShortName() + "/images/" + icon : Hudson.RESOURCE_PATH + "/images/16x16/" + icon;
    }
}

