/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.groovypostbuild;

import groovy.lang.GroovyShell;
import hudson.AbortException;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jvnet.hudson.plugins.groovypostbuild.GroovyPostbuildAction;
import org.jvnet.hudson.plugins.groovypostbuild.GroovyPostbuildSummaryAction;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPostbuildRecorder
extends Recorder {
    private static final Logger LOGGER = Logger.getLogger(GroovyPostbuildRecorder.class.getName());
    private final String groovyScript;

    @DataBoundConstructor
    public GroovyPostbuildRecorder(String groovyScript) {
        this.groovyScript = groovyScript;
        LOGGER.fine("GroovyPostbuildRecorder created with groovyScript:\n" + groovyScript);
    }

    public final Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        LOGGER.fine("perform() called for script:\n" + this.groovyScript);
        BadgeManager badgeManager = new BadgeManager(build, listener);
        GroovyShell shell = new GroovyShell();
        shell.setVariable("manager", (Object)badgeManager);
        try {
            shell.evaluate(this.groovyScript);
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Failed to evaluate groovy script."));
        }
        for (AbstractBuild b : badgeManager.builds) {
            b.save();
        }
        return build.getResult().isBetterThan(Result.FAILURE);
    }

    public final BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getGroovyScript() {
        return this.groovyScript;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BadgeManager {
        private AbstractBuild<?, ?> build;
        private final BuildListener listener;
        private final Set<AbstractBuild<?, ?>> builds = new HashSet();

        public BadgeManager(AbstractBuild<?, ?> build, BuildListener listener) {
            this.setBuild(build);
            this.listener = listener;
        }

        public Hudson getHudson() {
            return Hudson.getInstance();
        }

        public AbstractBuild<?, ?> getBuild() {
            return this.build;
        }

        public void setBuild(AbstractBuild<?, ?> build) {
            if (build != null) {
                this.build = build;
                this.builds.add(build);
            }
        }

        public boolean setBuildNumber(int buildNumber) {
            AbstractBuild newBuild = (AbstractBuild)this.build.getProject().getBuildByNumber(buildNumber);
            this.setBuild(newBuild);
            return newBuild != null;
        }

        public BuildListener getListener() {
            return this.listener;
        }

        public void addShortText(String text) {
            this.build.getActions().add(GroovyPostbuildAction.createShortText(text));
        }

        public void addShortText(String text, String color, String background, String border, String borderColor) {
            this.build.getActions().add(GroovyPostbuildAction.createShortText(text, color, background, border, borderColor));
        }

        public void addBadge(String icon, String text) {
            this.build.getActions().add(GroovyPostbuildAction.createBadge(icon, text));
        }

        public void addInfoBadge(String text) {
            this.build.getActions().add(GroovyPostbuildAction.createInfoBadge(text));
        }

        public void addWarningBadge(String text) {
            this.build.getActions().add(GroovyPostbuildAction.createWarningBadge(text));
        }

        public void addErrorBadge(String text) {
            this.build.getActions().add(GroovyPostbuildAction.createErrorBadge(text));
        }

        public void removeBadges() {
            List actions = this.build.getActions();
            List badgeActions = this.build.getActions(GroovyPostbuildAction.class);
            for (GroovyPostbuildAction action : badgeActions) {
                actions.remove(action);
            }
        }

        public void removeBadge(int index) {
            List actions = this.build.getActions();
            List badgeActions = this.build.getActions(GroovyPostbuildAction.class);
            if (index < 0 || index >= badgeActions.size()) {
                this.listener.error("Invalid badge index: " + index + ". Allowed values: 0 .. " + (badgeActions.size() - 1));
            } else {
                GroovyPostbuildAction action = (GroovyPostbuildAction)badgeActions.get(index);
                actions.remove(action);
            }
        }

        public GroovyPostbuildSummaryAction createSummary(String icon) {
            GroovyPostbuildSummaryAction action = new GroovyPostbuildSummaryAction(icon);
            this.build.getActions().add(action);
            return action;
        }

        public void removeSummaries() {
            List actions = this.build.getActions();
            List summaryActions = this.build.getActions(GroovyPostbuildSummaryAction.class);
            for (GroovyPostbuildSummaryAction action : summaryActions) {
                actions.remove(action);
            }
        }

        public void removeSummary(int index) {
            List actions = this.build.getActions();
            List summaryActions = this.build.getActions(GroovyPostbuildSummaryAction.class);
            if (index < 0 || index >= summaryActions.size()) {
                this.listener.error("Invalid summary index: " + index + ". Allowed values: 0 .. " + (summaryActions.size() - 1));
            } else {
                GroovyPostbuildSummaryAction action = (GroovyPostbuildSummaryAction)summaryActions.get(index);
                actions.remove(action);
            }
        }

        public void buildUnstable() {
            this.build.setResult(Result.UNSTABLE);
        }

        public void buildFailure() {
            this.build.setResult(Result.FAILURE);
        }

        public void buildSuccess() {
            this.build.setResult(Result.SUCCESS);
        }

        public boolean logContains(String regexp) {
            return this.contains(this.build.getLogFile(), regexp);
        }

        public boolean contains(File f, String regexp) {
            Matcher matcher = this.getMatcher(f, regexp);
            return matcher != null && matcher.matches();
        }

        public Matcher getLogMatcher(String regexp) {
            return this.getMatcher(this.build.getLogFile(), regexp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Matcher getMatcher(File f, String regexp) {
            LOGGER.info("Searching for '" + regexp + "' in '" + f + "'.");
            Matcher matcher = null;
            BufferedReader reader = null;
            try {
                String line;
                Pattern pattern = this.compilePattern(regexp);
                reader = new BufferedReader(new FileReader(f));
                while ((line = reader.readLine()) != null) {
                    Matcher m = pattern.matcher(line);
                    if (!m.matches()) continue;
                    matcher = m;
                    break;
                }
            }
            catch (IOException e) {
                try {
                    e.printStackTrace(this.listener.error("Groovy Postbuild: getMatcher(\"" + f + "\", \"" + regexp + "\") failed."));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            return matcher;
        }

        private Pattern compilePattern(String regexp) throws AbortException {
            Pattern pattern;
            try {
                pattern = Pattern.compile(regexp);
            }
            catch (PatternSyntaxException e) {
                this.listener.getLogger().println("Groovy Postbuild: Unable to compile regular expression '" + regexp + "'");
                throw new AbortException();
            }
            return pattern;
        }
    }
}

