/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.groovy.Groovy;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Groovy
extends Builder {
    private BuilderType type;
    private String groovyName;
    private String command;
    private String scriptFile;
    private String parameters;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    Groovy(BuilderType type, String groovyName, String command, String scriptFile, String parameters) {
        this.type = type;
        this.groovyName = groovyName;
        this.command = command;
        this.scriptFile = scriptFile;
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        AbstractProject proj = build.getProject();
        FilePath ws = proj.getWorkspace();
        FilePath script = null;
        if (this.type == BuilderType.FILE) {
            script = new FilePath(ws, this.scriptFile);
        } else {
            try {
                script = ws.createTextTempFile("hudson", ".groovy", this.command, true);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to produce a script file"));
                return false;
            }
        }
        try {
            int result;
            String[] cmd = this.buildCommandLine(script);
            try {
                Map envVars = build.getEnvVars();
                GroovyInstallation installation = this.getGroovy();
                if (installation != null) {
                    envVars.put("GROOVY_HOME", installation.getHome());
                }
                for (Map.Entry e : build.getBuildVariables().entrySet()) {
                    envVars.put(e.getKey(), e.getValue());
                }
                result = launcher.launch(cmd, envVars, (OutputStream)listener.getLogger(), ws).join();
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("command execution failed"));
                result = -1;
            }
            boolean bl = result == 0;
            return bl;
        }
        finally {
            try {
                if (this.type == BuilderType.COMMAND && script != null) {
                    script.delete();
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to delete script file " + script));
            }
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    protected GroovyInstallation getGroovy() {
        return DescriptorImpl.getGroovy((String)this.groovyName);
    }

    protected String[] buildCommandLine(FilePath script) throws IOException, InterruptedException {
        ArrayList<String> list = new ArrayList<String>();
        String cmd = "groovy";
        GroovyInstallation installation = this.getGroovy();
        if (installation != null) {
            cmd = installation.getExecutable(script.getChannel());
        }
        list.add(cmd);
        if (this.parameters != null) {
            StringTokenizer tokens = new StringTokenizer(this.parameters);
            while (tokens.hasMoreTokens()) {
                list.add(tokens.nextToken());
            }
        }
        list.add(script.getRemote());
        return list.toArray(new String[0]);
    }

    public String getCommand() {
        return this.command;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public String getGroovyName() {
        return this.groovyName;
    }

    public BuilderType getType() {
        return this.type;
    }

    public String getParameters() {
        return this.parameters;
    }
}

