/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import groovy.lang.GroovyShell;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.tasks.Builder;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemGroovy
extends Builder {
    private String command;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    SystemGroovy(String command) {
        this.command = command;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        GroovyShell shell = new GroovyShell();
        shell.setVariable("out", (Object)listener.getLogger());
        Object output = shell.evaluate(this.command);
        if (output instanceof Boolean) {
            return (Boolean)output;
        }
        if (output != null) {
            listener.getLogger().println("Script returned: " + output);
        }
        if (output instanceof Number) {
            return ((Number)output).intValue() == 0;
        }
        return true;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getCommand() {
        return this.command;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        DescriptorImpl() {
            super(SystemGroovy.class);
            this.load();
        }

        public String getDisplayName() {
            return "Execute system Groovy script";
        }

        public Builder newInstance(StaplerRequest req) throws Descriptor.FormException {
            String cmd = req.getParameter("groovy.system_command");
            return new SystemGroovy(cmd);
        }

        public String getHelpFile() {
            return "/plugin/groovy/systemscript-projectconfig.html";
        }
    }
}

