/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.model.Descriptor;
import hudson.plugins.groovy.ScriptSource;
import hudson.tasks.Builder;
import hudson.util.DescriptorList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AbstractGroovy
extends Builder {
    public ScriptSource scriptSource;

    public AbstractGroovy(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public ScriptSource getScriptSource() {
        return this.scriptSource;
    }

    public static Properties parseProperties(String properties) throws IOException {
        Properties props = new Properties();
        if (properties != null) {
            try {
                props.load(new StringReader(properties));
            }
            catch (NoSuchMethodError err) {
                props.load(new ByteArrayInputStream(properties.getBytes()));
            }
        }
        return props;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractGroovyDescriptor
    extends Descriptor<Builder> {
        private AtomicInteger instanceCounter = new AtomicInteger(0);

        public AbstractGroovyDescriptor(Class<? extends Builder> clazz) {
            super(clazz);
        }

        protected ScriptSource getScriptSource(StaplerRequest req, JSONObject data) throws Descriptor.FormException {
            Object scriptSourceObject = data.get("scriptSource");
            if (scriptSourceObject instanceof JSONArray) {
                JSONArray scriptSourceJSONArray = (JSONArray)scriptSourceObject;
                JSONObject scriptSourceJSONObject = new JSONObject();
                Object nestedObject = scriptSourceJSONArray.get(1);
                if (nestedObject instanceof JSONObject) {
                    scriptSourceJSONObject.putAll((Map)((JSONObject)nestedObject));
                    scriptSourceJSONObject.put((Object)"value", scriptSourceJSONArray.get(0));
                    data.put((Object)"scriptSource", (Object)scriptSourceJSONObject);
                }
            }
            return (ScriptSource)ScriptSource.SOURCES.newInstanceFromRadioList(data, "scriptSource");
        }

        public static DescriptorList<ScriptSource> getScriptSources() {
            return ScriptSource.SOURCES;
        }

        public int nextInstanceID() {
            return this.instanceCounter.incrementAndGet();
        }
    }
}

