/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.StructuredForm;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.groovy.AbstractGroovy;
import hudson.plugins.groovy.FileScriptSource;
import hudson.plugins.groovy.ScriptSource;
import hudson.plugins.groovy.StringScriptSource;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Builder;
import hudson.util.NullStream;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Groovy
extends AbstractGroovy {
    private String groovyName;
    private String parameters;
    private String scriptParameters;
    private String properties;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private BuilderType type;
    private String command;
    private String scriptFile;

    public Groovy(ScriptSource scriptSource, String groovyName, String parameters, String scriptParameters, String properties) {
        super(scriptSource);
        this.groovyName = groovyName;
        this.parameters = parameters;
        this.scriptParameters = scriptParameters;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.scriptSource == null) {
            listener.fatalError("There is no script configured for this builder");
            return false;
        }
        AbstractProject proj = build.getProject();
        FilePath ws = proj.getWorkspace();
        FilePath script = null;
        try {
            script = this.scriptSource.getScriptFile(ws);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to produce a script file"));
            return false;
        }
        try {
            int result;
            String[] cmd = this.buildCommandLine(script);
            try {
                Map envVars = build.getEnvVars();
                GroovyInstallation installation = this.getGroovy();
                if (installation != null) {
                    envVars.put("GROOVY_HOME", installation.getHome());
                }
                for (Map.Entry e : build.getBuildVariables().entrySet()) {
                    envVars.put(e.getKey(), e.getValue());
                }
                if (this.properties != null) {
                    String origJavaOpts = (String)build.getBuildVariables().get("JAVA_OPTS");
                    StringBuffer javaOpts = new StringBuffer(origJavaOpts != null ? origJavaOpts : "");
                    Properties props = Groovy.parseProperties(this.properties);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        javaOpts.append(" -D" + entry.getKey() + "=" + entry.getValue());
                    }
                    envVars.put("JAVA_OPTS", javaOpts.toString());
                }
                result = launcher.launch(cmd, envVars, (OutputStream)listener.getLogger(), ws).join();
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("command execution failed"));
                result = -1;
            }
            boolean bl = result == 0;
            return bl;
        }
        finally {
            try {
                if (this.type == BuilderType.COMMAND && script != null) {
                    script.delete();
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to delete script file " + script));
            }
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    protected GroovyInstallation getGroovy() {
        return DescriptorImpl.getGroovy(this.groovyName);
    }

    protected String[] buildCommandLine(FilePath script) throws IOException, InterruptedException {
        StringTokenizer tokens;
        ArrayList<String> list = new ArrayList<String>();
        String cmd = "groovy";
        GroovyInstallation installation = this.getGroovy();
        if (installation != null) {
            cmd = installation.getExecutable(script.getChannel());
        }
        list.add(cmd);
        if (this.parameters != null) {
            tokens = new StringTokenizer(this.parameters);
            while (tokens.hasMoreTokens()) {
                list.add(tokens.nextToken());
            }
        }
        list.add(script.getRemote());
        if (this.scriptParameters != null) {
            tokens = new StringTokenizer(this.scriptParameters);
            while (tokens.hasMoreTokens()) {
                list.add(tokens.nextToken());
            }
        }
        return list.toArray(new String[0]);
    }

    public String getCommand() {
        return this.command;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public String getGroovyName() {
        return this.groovyName;
    }

    public BuilderType getType() {
        return this.type;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getScriptParameters() {
        return this.scriptParameters;
    }

    public String getProperties() {
        return this.properties;
    }

    private Object readResolve() {
        if (this.type != null) {
            switch (this.type) {
                case COMMAND: {
                    this.scriptSource = new StringScriptSource(this.command);
                    break;
                }
                case FILE: {
                    this.scriptSource = new FileScriptSource(this.scriptFile);
                }
            }
        }
        this.type = null;
        this.command = null;
        this.scriptFile = null;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuilderType {
        COMMAND,
        FILE;

    }

    public static final class GroovyInstallation
    implements Serializable {
        private final String name;
        private final String home;
        private static final long serialVersionUID = 1L;

        @DataBoundConstructor
        public GroovyInstallation(String name, String home) {
            this.name = name;
            this.home = home;
        }

        public String getHome() {
            return this.home;
        }

        public String getName() {
            return this.name;
        }

        public String getExecutable(VirtualChannel channel) throws IOException, InterruptedException {
            return (String)channel.call((Callable)new Callable<String, IOException>(){

                public String call() throws IOException {
                    File exe = GroovyInstallation.this.getExeFile("groovy");
                    if (exe.exists()) {
                        return exe.getPath();
                    }
                    return null;
                }
            });
        }

        private File getExeFile(String execName) {
            if (File.separatorChar == '\\') {
                execName = execName + ".exe";
            }
            return new File(this.getHome(), "bin/" + execName);
        }

        public boolean exists() {
            try {
                return this.getExecutable(new Launcher.LocalLauncher((TaskListener)new StreamTaskListener((OutputStream)new NullStream())).getChannel()) != null;
            }
            catch (IOException e) {
                return false;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
    }

    public static final class DescriptorImpl
    extends AbstractGroovy.AbstractGroovyDescriptor {
        private volatile GroovyInstallation[] installations = new GroovyInstallation[0];

        DescriptorImpl() {
            super(Groovy.class);
            this.load();
        }

        public String getDisplayName() {
            return "Execute Groovy script";
        }

        public String getHelpFile() {
            return "/plugin/groovy/project-config.html";
        }

        public GroovyInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req) {
            this.installations = req.bindJSONToList(GroovyInstallation.class, StructuredForm.get((StaplerRequest)req).get("groovy")).toArray(new GroovyInstallation[0]);
            this.save();
            return true;
        }

        public Builder newInstance(StaplerRequest req, JSONObject data) throws Descriptor.FormException {
            ScriptSource source = this.getScriptSource(req, data);
            String instName = data.getString("groovyName");
            String params = data.getString("parameters");
            String scriptParams = data.getString("scriptParameters");
            String props = data.getString("properties");
            return new Groovy(source, instName, params, scriptParams, props);
        }

        public static GroovyInstallation getGroovy(String groovyName) {
            for (GroovyInstallation i : DESCRIPTOR.getInstallations()) {
                if (groovyName == null || !i.getName().equals(groovyName)) continue;
                return i;
            }
            return null;
        }
    }
}

