/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.plugins.groovy.ScriptSource;
import java.io.IOException;
import java.io.InputStream;
import net.sf.json.JSONObject;
import org.codehaus.plexus.util.StringInputStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class StringScriptSource
implements ScriptSource {
    private String command;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public StringScriptSource(String command) {
        this.command = command;
    }

    public InputStream getScriptStream(FilePath projectWorkspace) {
        return new StringInputStream(this.command);
    }

    public FilePath getScriptFile(FilePath projectWorkspace) throws IOException, InterruptedException {
        return projectWorkspace.createTextTempFile("hudson", ".groovy", this.command, true);
    }

    public String getCommand() {
        return this.command;
    }

    public Descriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends Descriptor {
        public DescriptorImpl() {
            super(StringScriptSource.class);
        }

        public String getDisplayName() {
            return "Groovy command";
        }

        public ScriptSource newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (ScriptSource)req.bindJSON(StringScriptSource.class, formData);
        }
    }
}

