/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.groovy.AbstractGroovy;
import hudson.plugins.groovy.FileScriptSource;
import hudson.plugins.groovy.Groovy;
import hudson.plugins.groovy.ScriptSource;
import hudson.plugins.groovy.StringScriptSource;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Groovy
extends AbstractGroovy {
    private String groovyName;
    private String parameters;
    private String scriptParameters;
    private String properties;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private BuilderType type;
    private String command;
    private String scriptFile;

    public Groovy(ScriptSource scriptSource, String groovyName, String parameters, String scriptParameters, String properties) {
        super(scriptSource);
        this.groovyName = groovyName;
        this.parameters = parameters;
        this.scriptParameters = scriptParameters;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.scriptSource == null) {
            listener.fatalError("There is no script configured for this builder");
            return false;
        }
        AbstractProject proj = build.getProject();
        FilePath ws = proj.getWorkspace();
        FilePath script = null;
        try {
            script = this.scriptSource.getScriptFile(ws);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to produce a script file"));
            return false;
        }
        try {
            int result;
            String[] cmd = this.buildCommandLine(script);
            try {
                Map envVars = build.getEnvVars();
                GroovyInstallation installation = this.getGroovy();
                if (installation != null) {
                    envVars.put("GROOVY_HOME", installation.getHome());
                }
                for (Map.Entry e : build.getBuildVariables().entrySet()) {
                    envVars.put(e.getKey(), e.getValue());
                }
                if (this.properties != null) {
                    String origJavaOpts = (String)build.getBuildVariables().get("JAVA_OPTS");
                    StringBuffer javaOpts = new StringBuffer(origJavaOpts != null ? origJavaOpts : "");
                    Properties props = Groovy.parseProperties((String)this.properties);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        javaOpts.append(" -D" + entry.getKey() + "=" + entry.getValue());
                    }
                    envVars.put("JAVA_OPTS", javaOpts.toString());
                }
                result = launcher.launch(cmd, envVars, (OutputStream)listener.getLogger(), ws).join();
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("command execution failed"));
                result = -1;
            }
            boolean bl = result == 0;
            return bl;
        }
        finally {
            try {
                if (this.type == BuilderType.COMMAND && script != null) {
                    script.delete();
                }
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to delete script file " + script));
            }
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    protected GroovyInstallation getGroovy() {
        return DescriptorImpl.getGroovy((String)this.groovyName);
    }

    protected String[] buildCommandLine(FilePath script) throws IOException, InterruptedException {
        StringTokenizer tokens;
        ArrayList<String> list = new ArrayList<String>();
        String cmd = "groovy";
        GroovyInstallation installation = this.getGroovy();
        if (installation != null) {
            cmd = installation.getExecutable(script.getChannel());
        }
        list.add(cmd);
        if (this.parameters != null) {
            tokens = new StringTokenizer(this.parameters);
            while (tokens.hasMoreTokens()) {
                list.add(tokens.nextToken());
            }
        }
        list.add(script.getRemote());
        if (this.scriptParameters != null) {
            tokens = new StringTokenizer(this.scriptParameters);
            while (tokens.hasMoreTokens()) {
                list.add(tokens.nextToken());
            }
        }
        return list.toArray(new String[0]);
    }

    public String getCommand() {
        return this.command;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public String getGroovyName() {
        return this.groovyName;
    }

    public BuilderType getType() {
        return this.type;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getScriptParameters() {
        return this.scriptParameters;
    }

    public String getProperties() {
        return this.properties;
    }

    private Object readResolve() {
        if (this.type != null) {
            switch (1.$SwitchMap$hudson$plugins$groovy$Groovy$BuilderType[this.type.ordinal()]) {
                case 1: {
                    this.scriptSource = new StringScriptSource(this.command);
                    break;
                }
                case 2: {
                    this.scriptSource = new FileScriptSource(this.scriptFile);
                }
            }
        }
        this.type = null;
        this.command = null;
        this.scriptFile = null;
        return this;
    }
}

