/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.groovy.AbstractGroovy;
import hudson.plugins.groovy.ScriptSource;
import hudson.plugins.groovy.StringScriptSource;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Map;
import net.sf.json.JSONObject;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemGroovy
extends AbstractGroovy {
    String bindings;
    String classpath;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private String command;

    @DataBoundConstructor
    public SystemGroovy(ScriptSource scriptSource, String bindings, String classpath) {
        super(scriptSource);
        this.bindings = bindings;
        this.classpath = classpath;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        if (this.classpath != null) {
            compilerConfig.setClasspath(this.classpath);
        }
        GroovyShell shell = new GroovyShell(new Binding((Map)SystemGroovy.parseProperties(this.bindings)), compilerConfig);
        shell.setVariable("out", (Object)listener.getLogger());
        Object output = shell.evaluate(this.getScriptSource().getScriptStream(build.getWorkspace()));
        if (output instanceof Boolean) {
            return (Boolean)output;
        }
        if (output != null) {
            listener.getLogger().println("Script returned: " + output);
        }
        if (output instanceof Number) {
            return ((Number)output).intValue() == 0;
        }
        return true;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    private Object readResolve() {
        if (this.command != null) {
            this.scriptSource = new StringScriptSource(this.command);
            this.command = null;
        }
        return this;
    }

    public String getCommand() {
        return this.command;
    }

    public String getBindings() {
        return this.bindings;
    }

    public String getClasspath() {
        return this.classpath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuilderType {
        COMMAND,
        FILE;

    }

    public static final class DescriptorImpl
    extends AbstractGroovy.AbstractGroovyDescriptor {
        DescriptorImpl() {
            super(SystemGroovy.class);
            this.load();
        }

        public String getDisplayName() {
            return "Execute system Groovy script";
        }

        public Builder newInstance(StaplerRequest req, JSONObject data) throws Descriptor.FormException {
            ScriptSource source = this.getScriptSource(req, data);
            String binds = data.getString("bindings");
            String classp = data.getString("classpath");
            return new SystemGroovy(source, binds, classp);
        }

        public String getHelpFile() {
            return "/plugin/groovy/systemscript-projectconfig.html";
        }
    }
}

