/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.groovy.FileScriptSource;
import hudson.plugins.groovy.ScriptSource;
import java.io.IOException;
import java.io.InputStream;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileScriptSource
implements ScriptSource {
    private String scriptFile;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public FileScriptSource(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    public FilePath getScriptFile(FilePath projectWorkspace) {
        return new FilePath(projectWorkspace, this.scriptFile);
    }

    public FilePath getScriptFile(FilePath projectWorkspace, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String expandedScriptdFile = env.expand(this.scriptFile);
        return new FilePath(projectWorkspace, expandedScriptdFile);
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public InputStream getScriptStream(FilePath projectWorkspace) throws IOException {
        return this.getScriptFile(projectWorkspace).read();
    }

    public InputStream getScriptStream(FilePath projectWorkspace, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        return this.getScriptFile(projectWorkspace, build, listener).read();
    }

    public Descriptor<ScriptSource> getDescriptor() {
        return DESCRIPTOR;
    }
}

