/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.groovy.ScriptSource;
import java.io.IOException;
import java.io.InputStream;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileScriptSource
implements ScriptSource {
    private String scriptFile;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public FileScriptSource(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    @Override
    public FilePath getScriptFile(FilePath projectWorkspace) {
        return new FilePath(projectWorkspace, this.scriptFile);
    }

    @Override
    public FilePath getScriptFile(FilePath projectWorkspace, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String expandedScriptdFile = env.expand(this.scriptFile);
        return new FilePath(projectWorkspace, expandedScriptdFile);
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    @Override
    public InputStream getScriptStream(FilePath projectWorkspace) throws IOException {
        return this.getScriptFile(projectWorkspace).read();
    }

    @Override
    public InputStream getScriptStream(FilePath projectWorkspace, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        return this.getScriptFile(projectWorkspace, build, listener).read();
    }

    public Descriptor<ScriptSource> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<ScriptSource> {
        public DescriptorImpl() {
            super(FileScriptSource.class);
        }

        public String getDisplayName() {
            return "Groovy script file";
        }

        public ScriptSource newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (ScriptSource)req.bindJSON(FileScriptSource.class, formData);
        }
    }
}

