/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.groovy;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.groovy.ScriptSource;
import java.io.IOException;
import java.io.InputStream;
import net.sf.json.JSONObject;
import org.codehaus.plexus.util.StringInputStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringScriptSource
implements ScriptSource {
    private String command;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public StringScriptSource(String command) {
        this.command = command;
    }

    @Override
    public InputStream getScriptStream(FilePath projectWorkspace) {
        return new StringInputStream(this.command);
    }

    @Override
    public InputStream getScriptStream(FilePath projectWorkspace, AbstractBuild<?, ?> build, BuildListener listener) {
        return this.getScriptStream(projectWorkspace);
    }

    @Override
    public FilePath getScriptFile(FilePath projectWorkspace) throws IOException, InterruptedException {
        return projectWorkspace.createTextTempFile("hudson", ".groovy", this.command, true);
    }

    @Override
    public FilePath getScriptFile(FilePath projectWorkspace, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        return this.getScriptFile(projectWorkspace);
    }

    public String getCommand() {
        return this.command;
    }

    public Descriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<ScriptSource> {
        public DescriptorImpl() {
            super(StringScriptSource.class);
        }

        public String getDisplayName() {
            return "Groovy command";
        }

        public ScriptSource newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (ScriptSource)req.bindJSON(StringScriptSource.class, formData);
        }
    }
}

