/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.growl;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.growl.GrowlPublisher;
import hudson.plugins.growl.MacGrowler;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.libgrowl.Application;
import net.sf.libgrowl.GrowlConnector;
import net.sf.libgrowl.Notification;
import net.sf.libgrowl.NotificationType;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GrowlPublisher
extends Notifier {
    private static final List<String> VALUES_REPLACED_WITH_NULL = Arrays.asList("", "(Default)", "(System Default)");
    private static final Logger LOGGER = Logger.getLogger(GrowlPublisher.class.getName());
    private final String appName = "Growler";
    private String IP;
    private Boolean onlyOnFailureOrRecovery;

    private GrowlPublisher(String IP, Boolean onlyOnFailureOrRecovery) {
        this.onlyOnFailureOrRecovery = onlyOnFailureOrRecovery;
        this.IP = IP;
    }

    @DataBoundConstructor
    public GrowlPublisher(String IP, String onlyOnFailureOrRecovery) {
        this(GrowlPublisher.cleanToString((String)IP), GrowlPublisher.cleanToBoolean((String)onlyOnFailureOrRecovery));
    }

    private static String cleanToString(String string) {
        return VALUES_REPLACED_WITH_NULL.contains(string) ? null : string;
    }

    private static Boolean cleanToBoolean(String string) {
        Boolean result = null;
        if ("true".equals(string) || "Yes".equals(string)) {
            result = Boolean.TRUE;
        } else if ("false".equals(string) || "No".equals(string)) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private static String createTinyUrl(String url) throws IOException {
        HttpClient client = new HttpClient();
        GetMethod gm = new GetMethod("http://tinyurl.com/api-create.php?url=" + url.replace(" ", "%20"));
        int status = client.executeMethod((HttpMethod)gm);
        if (status == 200) {
            return gm.getResponseBodyAsString();
        }
        throw new IOException("Non-OK response code back from tinyurl: " + status);
    }

    private String createGrowlMessage(AbstractBuild<?, ?> build) {
        String projectName = build.getProject().getName();
        String result = build.getResult().toString();
        String tinyUrl = "";
        String absoluteBuildURL = ((DescriptorImpl)this.getDescriptor()).getUrl() + build.getUrl();
        try {
            tinyUrl = GrowlPublisher.createTinyUrl((String)absoluteBuildURL);
        }
        catch (Exception e) {
            tinyUrl = "?";
        }
        return String.format("Project: %s\nStatus: %s\nBuild Number: %d\nURL:%s", projectName, result, build.number, tinyUrl);
    }

    private boolean pingHost(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            return address.isReachable(10000);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getIP() {
        return this.IP;
    }

    public Boolean getOnlyOnFailureOrRecovery() {
        return this.onlyOnFailureOrRecovery;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.shouldgrowl(build)) {
            String password = ((DescriptorImpl)this.getDescriptor()).password;
            try {
                String[] clients = this.IP.replace(" ", "").split(",");
                for (int i = 0; i < clients.length; ++i) {
                    if (this.pingHost(clients[i])) {
                        LOGGER.log(Level.INFO, "Sending Growl to " + clients[i] + "...");
                        String message = this.createGrowlMessage(build);
                        GrowlConnector growl = new GrowlConnector(clients[i]);
                        growl.setPassword(password);
                        Application hudsonApp = new Application("Hudson");
                        hudsonApp.setIcon("http://hudson-ci.org/images/butler.png");
                        NotificationType buildNotify = new NotificationType("BuildNotify");
                        NotificationType[] notificationTypes = new NotificationType[]{buildNotify};
                        growl.register(hudsonApp, notificationTypes);
                        Notification hudsonNotify = new Notification(hudsonApp, buildNotify, "Hudson Build", message);
                        hudsonNotify.setSticky(true);
                        if (growl.notify(hudsonNotify) == 0) continue;
                        MacGrowler notifier = MacGrowler.register((String)"Growler", (String)password, (String)clients[i]);
                        notifier.notify("Growler", "Hudson Build", message, password);
                        continue;
                    }
                    LOGGER.log(Level.INFO, "Cannot send  Growl to " + clients[i] + ", host is down.");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to send growl.", e);
                return false;
            }
        }
        return true;
    }

    protected boolean shouldgrowl(AbstractBuild<?, ?> build) {
        if (this.onlyOnFailureOrRecovery == null) {
            if (((DescriptorImpl)this.getDescriptor()).onlyOnFailureOrRecovery) {
                return this.isFailureOrRecovery(build);
            }
            return true;
        }
        if (this.onlyOnFailureOrRecovery.booleanValue()) {
            return this.isFailureOrRecovery(build);
        }
        return true;
    }

    protected boolean isFailureOrRecovery(AbstractBuild<?, ?> build) {
        if (build.getResult() == Result.FAILURE || build.getResult() == Result.UNSTABLE) {
            return true;
        }
        if (build.getResult() == Result.SUCCESS) {
            AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
            return previousBuild != null && previousBuild.getResult() != Result.SUCCESS;
        }
        return false;
    }
}

