/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JobTrackerStartTask
implements Callable<Void, Exception>,
Runnable {
    private final File hudsonRoot;
    private final String hdfsUrl;
    private final String jobTrackerAddress;
    private transient JobTracker tracker;
    private static final long serialVersionUID = 1L;
    public static final int HTTP_PORT = 50030;

    JobTrackerStartTask(File hudsonRoot, String hdfsUrl, String jobTrackerAddress) {
        this.hudsonRoot = hudsonRoot;
        this.hdfsUrl = hdfsUrl;
        this.jobTrackerAddress = jobTrackerAddress;
    }

    @Override
    public void run() {
        try {
            this.tracker.offerService();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Void call() throws Exception {
        JobConf jc = new JobConf();
        jc.set("fs.default.name", this.hdfsUrl);
        jc.set("mapred.job.tracker", this.jobTrackerAddress);
        jc.set("mapred.job.tracker.http.address", "0.0.0.0:50030");
        jc.set("mapred.local.dir", new File(this.hudsonRoot, "hadoop/mapred").getPath());
        this.tracker = JobTracker.startTracker((JobConf)jc);
        new Thread((Runnable)this).start();
        return null;
    }
}

