/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.hadoop.DataNodeStartTask;
import hudson.plugins.hadoop.PluginImpl;
import hudson.plugins.hadoop.TaskTrackerStartTask;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SlaveStartTask
implements Callable<Void, IOException> {
    private final FilePath rootPath;
    private final TaskListener listener;
    private final String hdfsUrl;
    private final String jobTrackerAddress;
    private final String address;

    public SlaveStartTask(Computer c, TaskListener listener, String hdfsUrl, String address) throws MalformedURLException {
        this.rootPath = c.getNode().getRootPath();
        this.listener = listener;
        this.hdfsUrl = hdfsUrl;
        this.jobTrackerAddress = PluginImpl.get().getJobTrackerAddress();
        this.address = address;
    }

    public Void call() throws IOException {
        try {
            Channel channel = PluginImpl.createHadoopVM((File)new File(this.rootPath.getRemote()), (TaskListener)this.listener);
            channel.call((Callable)new DataNodeStartTask(this.hdfsUrl, this.rootPath.getRemote(), this.address));
            channel.call((Callable)new TaskTrackerStartTask(this.hdfsUrl, this.rootPath.getRemote(), this.address, this.jobTrackerAddress));
            return null;
        }
        catch (InterruptedException e) {
            throw new IOException2((Throwable)e);
        }
    }
}

