/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.hadoop;

import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.hadoop.PluginImpl;
import hudson.plugins.hadoop.SlaveStartTask;
import hudson.remoting.Callable;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComputerListenerImpl
extends ComputerListener {
    private static final Logger LOGGER = Logger.getLogger(ComputerListenerImpl.class.getName());

    public void onOnline(Computer c, TaskListener listener) {
        try {
            PluginImpl p = PluginImpl.get();
            String hdfsUrl = p.getHdfsUrl();
            if (hdfsUrl != null) {
                String address = this.decideAddress(c);
                if (address == null) {
                    listener.getLogger().println("Unable to determine the hostname/IP address of this system. Skipping Hadoop deployment");
                } else {
                    c.getChannel().call((Callable)new SlaveStartTask(c, listener, hdfsUrl, address));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to start Hadoop"));
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.error("Failed to start Hadoop"));
        }
    }

    private String decideAddress(Computer c) throws IOException, InterruptedException {
        for (String address : (List)c.getChannel().call((Callable)new ListPossibleNames())) {
            try {
                InetAddress ia = InetAddress.getByName(address);
                if (!ia.isReachable(500)) continue;
                return ia.getCanonicalHostName();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to parse " + address, e);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListPossibleNames
    implements Callable<List<String>, IOException> {
        private static final long serialVersionUID = 1L;

        private ListPossibleNames() {
        }

        public List<String> call() throws IOException {
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress ia = e.nextElement();
                    if (ia.isLoopbackAddress()) continue;
                    names.add(ia.getHostAddress());
                }
            }
            return names;
        }
    }
}

